% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-FVP.R
\name{convert_FVP}
\alias{convert_FVP}
\title{Convert Force-Velocity profile back to Acceleration-Velocity profile}
\usage{
convert_FVP(
  F0,
  V0,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  wind_velocity = 0,
  ...
)
}
\arguments{
\item{F0, V0}{Numeric vectors. FV profile parameters}

\item{bodymass}{Body mass in kg. Used to calculate relative power and forwarded to \code{\link{get_air_resistance}}}

\item{inertia}{External inertia in kg (for example a weight vest, or a sled).
Not included in the air resistance calculation}

\item{resistance}{External horizontal resistance in Newtons (for example tether device or a sled friction resistance)}

\item{wind_velocity}{In meters per second (m/s). Use negative number as head
wind, and positive number as back wind. Default is 0m/s (no wind)}

\item{...}{Forwarded to \code{\link{predict_power_at_distance}}}
}
\value{
A list with calculated \code{MSS} and \code{MAC} parameters
}
\description{
This function converts back the Force-Velocity profile (FVP; F0 and V0 parameters) to
    Acceleration-Velocity profile (AVP; MSS and MAC parameters)
}
\examples{
FVP <- create_FVP(7, 8.3, inertia = 10, resistance = 50)

convert_FVP(FVP$F0, FVP$V0, inertia = 10, resistance = 50)
}
