% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-comparison-functions.R
\name{cid}
\alias{cid}
\title{Context specific interventional discrepancy}
\usage{
cid(object1, object2, FUN = mean)
}
\arguments{
\item{object1}{an object of class \code{\link{sevt}}.}

\item{object2}{an object of class \code{\link{sevt}}.}

\item{FUN}{a function that is used to aggregate CID for each variable.
The default \code{mean} will obtain the CID
as defined in Leonelli and Varando (2021).}
}
\value{
A list with components:
\itemize{
\item \code{wrong} a stages-like structure which record where
\code{object2} wrongly infer the interventional distance
with respect to \code{object1}.
\item \code{cid} the value of the computed CID.
}
}
\description{
Compute the context specific interventional discrepeancy
of a staged tree with respect to a reference staged tree.
}
\examples{
model1 <- stages_bhc(full(Titanic))
model2 <- stages_bhc(full(Titanic, 
                          order = c("Survived", "Sex", "Age", "Class")))
cid(model1, model2)$cid
cid(model1, model2)$wrong
}
\references{
Leonelli M., Varando G.
Context-Specific Causal Discovery for Categorical Data Using Staged Trees
\url{https://arxiv.org/abs/2106.04416}
}
