% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-inference-functions.R
\name{lr_test}
\alias{lr_test}
\title{Likelihood Ratio Test for staged trees models}
\usage{
lr_test(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{sevt}}.}

\item{...}{further objects of class \code{\link{sevt}}.
Must specify super-models of \code{object}.
See below for details.}
}
\value{
An object of class \code{anova}
which contains the log-likelihood,
degrees of freedom,
difference in degrees of freedom, likelihood ratio
statistics and corresponding p values.
}
\description{
Function to perform likelihood ratio test between
two or multiple staged event tree models.
}
\details{
If a single object of class \code{sevt} is passed as
argument, it computes
the likelihood-ratio test with respect to the
independence model.
If multiple objects are passed,
likelihood-ratio tests between the first
object and the followings are computed.
In the latter casem the function checks automatically if
the first model is nested in the additional ones,
via \code{\link{inclusions_stages}}, and throws
an error if not.
}
\examples{
data(PhDArticles)
order <- c("Gender", "Kids", "Married", "Articles")
phd.mod1 <- stages_hc(indep(PhDArticles, order))
phd.mod2 <- stages_hc(full(PhDArticles, order))

## compare two nested models
lr_test(phd.mod1, phd.mod2)

## compare a single model vs the independence model
lr_test(phd.mod1)
}
