% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-conversion-functions.R
\name{as_parentslist}
\alias{as_parentslist}
\alias{as_parentslist.bn}
\alias{as_parentslist.bn.fit}
\alias{as_parentslist.sevt}
\title{Obtain the equivalent DAG as list of parents}
\usage{
as_parentslist(x, ...)

\method{as_parentslist}{bn}(x, order = NULL, ...)

\method{as_parentslist}{bn.fit}(x, order = NULL, ...)

\method{as_parentslist}{sevt}(x, ...)
}
\arguments{
\item{x}{an R object.}

\item{...}{additional parameters.}

\item{order}{order of the variables, usually a topological order.}
}
\value{
An object of class \code{parentslist} for which a
print method exists.
Basically a list with
one entries for each variable with fields:
\itemize{
\item \code{parents} The parents of the variable.
\item \code{context} Where context independences are detected.
\item \code{partial} Where partial independences are detected.
\item \code{local} Where no context/partial independences are detected,
but local independences are present.
\item \code{values} values for the variable.
}
}
\description{
Convert to the equivalent representation as list of parents.
}
\details{
The output of this function is an object of class
\code{parentslist} which is one of the possible encoding for
a directed graph. This is mainly an internal class and its
specification can be changed in the future.
For example, now it may also include information on the
sample space of the variables and the context/partial/local
independences.

In \code{as_parentslist.sevt}, if a context-specific or a local-partial independence is detected
a message is printed and the minimal super-model is returned.
}
\examples{
model <- stages_hclust(full(Titanic), k = 2)
pl <- as_parentslist(model)
pl$Age 
}
\seealso{
\code{\link{print.parentslist}} and
\code{\link{as.character.parentslist}} for the parenthesis-encoding of the
DAG structure and the asymmetric independences.
}
