% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{standardize}
\alias{standardize}
\title{Standardized rates}
\usage{
standardize(x, label, standard_pop)
}
\arguments{
\item{x}{A fitted \code{surveil} model}

\item{label}{Labels (character strings) for the age groups that correspond to the values of \code{stand_pop}. The labels must match the grouping variable used to fit the model (i.e., \code{all(label \%in\% names(x$data$cases))} must be true).}

\item{standard_pop}{Standard population values corresponding to the age groups specified by \code{label}}
}
\value{
A list, also of class "stand_surveil", containing a summary data frame (mean and 95 percent credible intervals) (named \code{summary}), a data frame of MCMC samples of standardized rates per time period (named \code{samples}), and the user-provided labels and standard population sizes (named \code{label} and \code{standard_pop}). In addition, all of the items from the user-provided \code{surveil} model are automatically appended to the list.
}
\description{
Convert \code{surveil} model results to age standardized rates using a fixed age distribution
}
\examples{
data(cancer)
data(standard)

head(standard)
head(cancer)

\donttest{
fit <- stan_rw(cancer,
              time = Year,
              group = Age               
              )

stands <- standardize(fit,
                      label = standard$age,
                      standard_pop = standard$standard_pop)
print(stands)
plot(stands, style = "lines")
}
}
\seealso{
\code{\link[surveil]{stan_rw}}  \code{\link[surveil]{plot.stand_surveil}} \code{\link[surveil]{print.stand_surveil}}
}
