% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-diff.R
\name{surveil_diff}
\alias{surveil_diff}
\alias{plot.surveil_diff}
\alias{print.surveil_diff}
\title{Methods for \code{surveil_diff} objects}
\usage{
\method{plot}{surveil_diff}(
  x,
  style = c("mean_qi", "lines"),
  M = 250,
  col = "black",
  fill = "gray80",
  lwd,
  alpha,
  plot = TRUE,
  scale = 1e+05,
  PAR = TRUE,
  ncol = 3,
  base_size = 14,
  ...
)

\method{print}{surveil_diff}(x, scale = 1, ...)
}
\arguments{
\item{x}{Object of class \code{surveil_diff}, as returned by calling \code{group_diff} on a fitted \code{surveil} model}

\item{style}{If \code{style = "mean_qi"}, then the posterior mean and 95 percent credible interval will be plotted; if \code{style = "lines"}, then \code{M} samples from the joint probability distribution of the annual rates will be plotted.}

\item{M}{If \code{style = "lines"}, then \code{M} is the number of samples from the posterior distribution that will be plotted; the default is \code{M = 250}.}

\item{col}{Line color}

\item{fill}{Fill color for credible intervals, passed to \code{geom_ribbon}}

\item{lwd}{Linewidth}

\item{alpha}{transparency; for \verb{style = "mean_qi", controls the credible interval shading; for }style = "lines"`, this is applied to the lines}

\item{plot}{If \code{plot = FALSE}, a list of \code{ggplot}s will be returned}

\item{scale}{Print rates and rate differences as per \code{scale} at risk, e.g., per 10,000 at risk.}

\item{PAR}{Return population attributable risk? IF \code{FALSE}, then the rate ratio will be used instead of PAR.}

\item{ncol}{Number of columns for the plotting device. If \code{ncol = 1}, the three plots will be aligned vertically in one column; if \code{ncol = 3} they will b aligned horizontally in one row.}

\item{base_size}{Passed to \code{theme_classic} to control size of plot elements (e.g., text)}

\item{...}{additional print arguments}
}
\value{
\subsection{plot.surveil_diff}{

By default or whenever \code{plot = TRUE}, the plot method draws a series of plots to the current plotting device using \code{\link[gridExtra]{grid.arrange}}. If \code{plot = FALSE}, then a list of \code{ggplot}s is returned.
}

\subsection{print.surveil_diff}{

The print method returns nothing and prints a summary of results to the console.
}
}
\description{
Methods for \code{surveil_diff} objects

print surveil_diff objects for analyses of inequality
}
