% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-utils.R
\name{Model_data}
\alias{Model_data}
\title{R6 class to represent data to be used in estimating a model}
\description{
R6 class to represent data to be used in estimating a model

R6 class to represent data to be used in estimating a model
}
\details{
This class provides consistent names and interfaces to data which will
be used in a supervised regression / classification model.
}
\examples{

## ------------------------------------------------
## Method `Model_data$new`
## ------------------------------------------------

library("dplyr")
df <- dplyr::tibble(
    uid = 1:100,
    x1 = rnorm(100),
    x2 = rnorm(100),
    x3 = sample(4, 100, replace = TRUE)
) \%>\% dplyr::mutate(
    y = x1 + x2 + x3 + rnorm(100),
    x3 = factor(x3)
)
df <- make_splits(df, uid, .num_splits = 5)
data <- Model_data$new(df, y, x1, x2, x3)
}
\seealso{
\link[SuperLearner:SuperLearner.CV.control]{SuperLearner::SuperLearner.CV.control}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{label}}{The labels for the eventual model as a vector.}

\item{\code{features}}{The matrix representation of the data to be used for model fitting.
Constructed using \code{stats::model.matrix}.}

\item{\code{model_frame}}{The data-frame representation of the data as constructed by
\code{stats::model.frame}.}

\item{\code{split_id}}{The split identifiers as a vector.}

\item{\code{num_splits}}{The integer number of splits in the data.}

\item{\code{cluster}}{A cluster ID as a vector, constructed using the unit identifiers.}

\item{\code{weights}}{The case-weights as a vector.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Model_data-new}{\code{Model_data$new()}}
\item \href{#method-Model_data-SL_cv_control}{\code{Model_data$SL_cv_control()}}
\item \href{#method-Model_data-clone}{\code{Model_data$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model_data-new"></a>}}
\if{latex}{\out{\hypertarget{method-Model_data-new}{}}}
\subsection{Method \code{new()}}{
Creates an R6 object to represent data to be used in a prediction model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model_data$new(data, label_col, ..., .weight_col = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The full dataset to populate the class with.}

\item{\code{label_col}}{The unquoted name of the column to use as the label in
supervised learning models.}

\item{\code{...}}{The unquoted names of features to use in the model.}

\item{\code{.weight_col}}{The unquoted name of the column to use as case-weights
in subsequent models.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Model_data} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library("dplyr")
df <- dplyr::tibble(
    uid = 1:100,
    x1 = rnorm(100),
    x2 = rnorm(100),
    x3 = sample(4, 100, replace = TRUE)
) \%>\% dplyr::mutate(
    y = x1 + x2 + x3 + rnorm(100),
    x3 = factor(x3)
)
df <- make_splits(df, uid, .num_splits = 5)
data <- Model_data$new(df, y, x1, x2, x3)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model_data-SL_cv_control"></a>}}
\if{latex}{\out{\hypertarget{method-Model_data-SL_cv_control}{}}}
\subsection{Method \code{SL_cv_control()}}{
A helper function to create the cross-validation options to be used by SuperLearner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model_data$SL_cv_control()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model_data-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Model_data-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model_data$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
