% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cfg.R
\name{SLLearner_cfg}
\alias{SLLearner_cfg}
\title{Configuration of SuperLearner Submodel}
\description{
\code{SLLearner_cfg} is a configuration class for a single
sublearner to be included in SuperLearner. By constructing with a named list
of hyperparameters, this configuration allows distinct submodels
for each unique combination of hyperparameters. To understand what models
and hyperparameters are available, examine the methods listed in
\code{SuperLearner::listWrappers("SL")}.
}
\examples{

## ------------------------------------------------
## Method `SLLearner_cfg$new`
## ------------------------------------------------

SLLearner_cfg$new("SL.glm")
SLLearner_cfg$new("SL.gam", list(deg.gam = c(2, 3)))
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model_name}}{The name of the model as passed to \code{SuperLearner}
through the \code{SL.library} parameter.}

\item{\code{hyperparameters}}{Named list from hyperparameter name to a vector of
values that should be swept over.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SLLearner_cfg-new}{\code{SLLearner_cfg$new()}}
\item \href{#method-SLLearner_cfg-clone}{\code{SLLearner_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SLLearner_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-SLLearner_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{SLLearner_cfg} object with specified model name and hyperparameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLLearner_cfg$new(model_name, hp = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_name}}{The name of the model as passed to \code{SuperLearner}
through the \code{SL.library} parameter.}

\item{\code{hp}}{Named list from hyperparameter name to a vector of values that should be
swept over. Hyperparameters not included in this list are left at their SuperLearner
default values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{SLLearner_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{SLLearner_cfg$new("SL.glm")
SLLearner_cfg$new("SL.gam", list(deg.gam = c(2, 3)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SLLearner_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SLLearner_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLLearner_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
