% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop-odds.r
\name{prop.odds}
\alias{prop.odds}
\title{Fit Semiparametric Proportional 0dds Model}
\usage{
prop.odds(
  formula,
  data = sys.parent(),
  beta = NULL,
  Nit = 20,
  detail = 0,
  start.time = 0,
  max.time = NULL,
  id = NULL,
  n.sim = 500,
  weighted.test = 0,
  profile = 1,
  sym = 0,
  baselinevar = 1,
  clusters = NULL,
  max.clust = 1000,
  weights = NULL
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a '~'
operator, and the terms on the right.  The response must be a Event object
as returned by the `Event' function.}

\item{data}{a data.frame with the variables.}

\item{beta}{starting value for relative risk estimates}

\item{Nit}{number of iterations for Newton-Raphson algorithm.}

\item{detail}{if 0 no details is printed during iterations, if 1 details are
given.}

\item{start.time}{start of observation period where estimates are computed.}

\item{max.time}{end of observation period where estimates are computed.
Estimates thus computed from [start.time, max.time].  This is very useful to
obtain stable estimates, especially for the baseline. Default is max of
data.}

\item{id}{For timevarying covariates the variable must associate each record
with the id of a subject.}

\item{n.sim}{number of simulations in resampling.}

\item{weighted.test}{to compute a variance weighted version of the
test-processes used for testing time-varying effects.}

\item{profile}{if profile is 1 then modified partial likelihood is used,
profile=0 fits by simple estimating equation. The modified partial
likelihood is recommended.}

\item{sym}{to use symmetrized second derivative in the case of the
estimating equation approach (profile=0).  This may improve the numerical
performance.}

\item{baselinevar}{set to 0 to omit calculations of baseline variance.}

\item{clusters}{to compute cluster based standard errors.}

\item{max.clust}{number of maximum clusters to be used, to save time in iid
decomposition.}

\item{weights}{weights for score equations.}
}
\value{
returns an object of type 'cox.aalen'. With the following arguments:

\item{cum}{cumulative timevarying regression coefficient estimates are
computed within the estimation interval.} \item{var.cum}{the martingale
based pointwise variance estimates.  } \item{robvar.cum}{robust pointwise
variances estimates.  } \item{gamma}{estimate of proportional odds
parameters of model.} \item{var.gamma}{variance for gamma.  }
\item{robvar.gamma}{robust variance for gamma.  } \item{residuals}{list with
residuals. Estimated martingale increments (dM) and corresponding time
vector (time).} \item{obs.testBeq0}{observed absolute value of supremum of
cumulative components scaled with the variance.}
\item{pval.testBeq0}{p-value for covariate effects based on supremum test.}
\item{sim.testBeq0}{resampled supremum values.} \item{obs.testBeqC}{observed
absolute value of supremum of difference between observed cumulative process
and estimate under null of constant effect.} \item{pval.testBeqC}{p-value
based on resampling.} \item{sim.testBeqC}{resampled supremum values.}
\item{obs.testBeqC.is}{observed integrated squared differences between
observed cumulative and estimate under null of constant effect.}
\item{pval.testBeqC.is}{p-value based on resampling.}
\item{sim.testBeqC.is}{resampled supremum values.}
\item{conf.band}{resampling based constant to construct robust 95\% uniform
confidence bands. } \item{test.procBeqC}{observed test-process of difference
between observed cumulative process and estimate under null of constant
effect over time.} \item{loglike}{modified partial likelihood, pseudo
profile likelihood for regression parameters.} \item{D2linv}{inverse of the
derivative of the score function.} \item{score}{value of score for final
estimates.} \item{test.procProp}{observed score process for proportional
odds regression effects.} \item{pval.Prop}{p-value based on resampling.}
\item{sim.supProp}{re-sampled supremum values.}
\item{sim.test.procProp}{list of 50 random realizations of test-processes
for constant proportional odds under the model based on resampling.}
}
\description{
Fits a semiparametric proportional odds model: \deqn{ logit(1-S_Z(t)) =
log(G(t)) + \beta^T Z } where G(t) is increasing but otherwise unspecified.
Model is fitted by maximising the modified partial likelihood.  A
goodness-of-fit test by considering the score functions is also computed by
resampling methods.
}
\details{
The modelling formula uses the standard survival modelling given in the
\bold{survival} package.

For large data sets use the divide.conquer.timereg of the mets package to
run the model on splits of the data, or the alternative estimator by the
cox.aalen function.

The data for a subject is presented as multiple rows or "observations", each
of which applies to an interval of observation (start, stop]. The program
essentially assumes no ties, and if such are present a little random noise
is added to break the ties.
}
\examples{

data(sTRACE)
# Fits Proportional odds model 
out<-prop.odds(Event(time,status==9)~age+diabetes+chf+vf+sex,
sTRACE,max.time=7,n.sim=100)
summary(out)

par(mfrow=c(2,3))
plot(out,sim.ci=2)
plot(out,score=1) 

pout <- predict(out,Z=c(70,0,0,0,0))
plot(pout)

### alternative estimator for large data sets 
form <- Surv(time,status==9)~age+diabetes+chf+vf+sex
pform <- timereg.formula(form)
out2<-cox.aalen(pform,data=sTRACE,max.time=7,
	propodds=1,n.sim=0,robust=0,detail=0,Nit=40)
summary(out2)

}
\references{
Martinussen and Scheike, Dynamic Regression Models for Survival
Data, Springer (2006).
}
\author{
Thomas Scheike
}
\keyword{survival}
