% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc2vec.R
\name{textmodel_doc2vec}
\alias{textmodel_doc2vec}
\title{Create distributed representation of documents}
\usage{
textmodel_doc2vec(x, model, group_data = FALSE)
}
\arguments{
\item{x}{a \link[quanteda:tokens]{quanteda::tokens} object.}

\item{model}{a textmodel_wordvector object.}

\item{group_data}{if \code{TRUE}, apply \code{dfm_group(x)} before creating document vectors.}
}
\value{
Returns a textmodel_docvector object with the following elements:
\item{values}{a matrix for document vectors.}
\item{dim}{the size of the document vectors.}
\item{concatenator}{the concatenator in \code{x}.}
\item{docvars}{document variables compied from \code{x}.}
\item{call}{the command used to execute the function.}
\item{version}{the version of the wordvector package.}
}
\description{
Create distributed representation of documents as weighted word vectors.
}
