% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_insertion.R
\name{prepare_insertion}
\alias{prepare_insertion}
\title{Prepare expectations for insertion}
\usage{
prepare_insertion(
  strings,
  indentation = 0,
  trim_left = FALSE,
  trim_right = FALSE
)
}
\arguments{
\item{strings}{Expectation strings. (List or Character)

As returned with \code{gxs_*} functions with \code{out = "return"}.}

\item{indentation}{Indentation to add. (Numeric)}

\item{trim_left}{Whether to trim whitespaces from the beginning of the collapsed string. (Logical)}

\item{trim_right}{Whether to trim whitespaces from the end of the collapsed string. (Logical)}
}
\value{
A string for insertion with \code{\link[rstudioapi:insertText]{rstudioapi::insertText()}}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Collapses a list/vector of expectation strings and adds the specified indentation.
}
\examples{
# Attach packages
library(xpectr)

\donttest{
df <- data.frame('a' = c(1, 2, 3), 'b' = c('t', 'y', 'u'),
                 stringsAsFactors = FALSE)

tests <- gxs_selection("df", out = "return")
for_insertion <- prepare_insertion(tests)
for_insertion
rstudioapi::insertText(for_insertion)
}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{inserters}
