library(xpectr)
context("initializeTestthatAddin()")

test_that("testing initializeTestthatAddin()", {
  xpectr::set_test_seed(42)

  ## Testing 'initializeTestthatAddin(insert = FALSE)'                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- initializeTestthatAddin(insert = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "character")
  # Testing values
  expect_equal(
    output_19148,
    c(
      " ",
      "test_that(\"testing ...()\", {",
      "  xpectr::set_test_seed(42)",
      " ",
      "  # ...",
      " ",
      "})",
      " "
    ),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    8L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    8L)
  ## Finished testing 'initializeTestthatAddin(insert = FALSE)'             ####

  xpectr::set_test_seed(10)
  # gxs_function(
  #   initializeTestthatAddin,
  #   args_values = list(
  #     "insert" = list(FALSE, NA, 0),
  #     "indentation" = list(0, 3, NA)
  #   ),
  #   indentation = 2
  # )

  ## Testing 'initializeTestthatAddin'                                        ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing initializeTestthatAddin(insert = FALSE, inde...
  xpectr::set_test_seed(42)
  # Assigning output
  output_15074 <- initializeTestthatAddin(insert = FALSE, indentation = 0)
  # Testing class
  expect_equal(
    class(output_15074),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15074,
    type = "character")
  # Testing values
  expect_equal(
    output_15074,
    c(" ", "test_that(\"testing ...()\", {", "  xpectr::set_test_seed(42)",
      " ", "  # ...", " ", "})", " "),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_15074),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_15074),
    8L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_15074)),
    8L)

  # Testing initializeTestthatAddin(insert = NA, indenta...
  # Changed from baseline: insert = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(initializeTestthatAddin(insert = NA, indentation = 0)),
    xpectr::strip("1 assertions failed:\n * Variable 'insert': May not be NA."),
    fixed = TRUE)

  # Testing initializeTestthatAddin(insert = 0, indentat...
  # Changed from baseline: insert = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(initializeTestthatAddin(insert = 0, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'insert': Must be of type",
                         " 'logical flag', not 'double'.")),
    fixed = TRUE)

  # Testing initializeTestthatAddin(insert = NULL, inden...
  # Changed from baseline: insert = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(initializeTestthatAddin(insert = NULL, indentation = 0)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'insert': Must be of type",
                         " 'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing initializeTestthatAddin(insert = FALSE, inde...
  # Changed from baseline: indentation = 3
  xpectr::set_test_seed(42)
  # Assigning output
  output_10851 <- initializeTestthatAddin(insert = FALSE, indentation = 3)
  # Testing class
  expect_equal(
    class(output_10851),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_10851,
    type = "character")
  # Testing values
  expect_equal(
    output_10851,
    c(" ", "test_that(\"testing ...()\", {", "  xpectr::set_test_seed(42)",
      " ", "  # ...", " ", "})", " "),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_10851),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_10851),
    8L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_10851)),
    8L)

  # Testing initializeTestthatAddin(insert = FALSE, inde...
  # Changed from baseline: indentation = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  expect_error(
    xpectr::strip_msg(initializeTestthatAddin(insert = FALSE, indentation = NA)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'indentation': Contains m",
                         "issing values (element 1).")),
    fixed = TRUE)

  # Testing initializeTestthatAddin(insert = FALSE, inde...
  # Changed from baseline: indentation = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_12745 <- initializeTestthatAddin(insert = FALSE, indentation = NULL)
  # Testing class
  expect_equal(
    class(output_12745),
    "character",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12745,
    type = "character")
  # Testing values
  expect_equal(
    output_12745,
    c(" ", "test_that(\"testing ...()\", {", "  xpectr::set_test_seed(42)",
      " ", "  # ...", " ", "})", " "),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_12745),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12745),
    8L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12745)),
    8L)

  ## Finished testing 'initializeTestthatAddin'                               ####
  #

})
