% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.nm.tables.R
\name{read.nm.tables}
\alias{read.nm.tables}
\title{Reading NONMEM table files}
\usage{
read.nm.tables(
  table.files = NULL,
  runno = NULL,
  tab.suffix = "",
  table.names = c("sdtab", "mutab", "patab", "catab", "cotab", "mytab", "extra", "xptab"),
  cwres.name = c("cwtab"),
  cwres.suffix = "",
  quiet = FALSE,
  new_methods = TRUE,
  ...
)
}
\arguments{
\item{table.files}{Exact names of table files to read.  If not provided then
the exact names are created using the other arguments to the function.}

\item{runno}{Run-number to identify sets of table files.}

\item{tab.suffix}{Table file name suffix.}

\item{table.names}{Vector of template table file names to read.}

\item{cwres.name}{Vector of CWRES table file names to read.}

\item{cwres.suffix}{CWRES table file name suffix.}

\item{quiet}{Logical value to indicate whether some warnings should be quiet
or not.}

\item{new_methods}{Should faster methods of reading tables be used (uses readr package)?}

\item{\dots}{Additional arguments passed to this function}
}
\value{
A dataframe.
}
\description{
Reads one or more NONMEM table files, removes duplicated columns and merges
the data into a data.frame.
}
\details{
Reads one or more table files, removes duplicate columns and merges the
data. The function also checks to see if the table files are of the same
length (required).

If there are header lines in the table files (for example if your data are
simulated with NSUB>1), these are removed.

The table file names to read are constructed from the file name templates of
\code{table.names}. The \code{runno} and \code{tab.suffix} are appended to
the file name template before checking if the file is readable.

Xpose expects, by default, to find the following NONMEM tables in the
working directory to be able to create an Xpose data object (using a run
number of 5 as an example):

sdtab5: The 'standard' parameters, including IWRE, IPRE, TIME, and the
NONMEM default items (DV, PRED, RES and WRES) that are added when NOAPPEND
is not present in the \code{$TABLE} record.

\code{   $TABLE ID TIME IPRE IWRE NOPRINT ONEHEADER FILE=sdtab5}

patab5: The empirical Bayes estimates of individual model parameter values,
or posthoc estimates. These are model parameters, such as CL, V2, ETA1, etc.

\code{   $TABLE ID CL V2 KA K F1 ETA1 ETA2 ETA3 NOPRINT NOAPPEND ONEHEADER
FILE=patab5 }

catab5: Categorical covariates, e.g. SEX, RACE.

\code{   $TABLE ID SEX HIV GRP NOPRINT NOAPPEND ONEHEADER FILE=catab5 }

cotab5: Continuous covariates, e.g. WT, AGE.

\code{   $TABLE ID WT AGE BSA HT GGT HB NOPRINT NOAPPEND ONEHEADER FILE=cotab5}

mutab5, mytab5, extra5, xptab5: Additional variables of any kind. These
might be useful if there are more covariates than can be accommodated in the
covariates tables, for example, or if you have other variables that should
be added, e.g. CMAX, AUC.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory, and that the table files have
## a suffix of '.dat', e.g. sdtab5.dat

my.dataframe <- read.nm.tables(5, tab.suffix = ".dat") 
}



}
\seealso{
\code{\link{xpose.data-class}}, \code{\link{compute.cwres}}

Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson, Andrew Hooker
}
\concept{data functions}
\keyword{methods}
