% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avar.R
\name{avar}
\alias{avar}
\title{Asymptotic variance of Estimator}
\usage{
avar(X, e, group = NULL, J = NULL)
}
\arguments{
\item{X}{A matrix or vector of independent variable(s)}

\item{e}{The residuals from the regression}

\item{group}{(optional) The cluster identifier (hhid from \code{projdummies})}

\item{J}{(optional) This is assumed to be X'X, and can be input if pre-calculated}
}
\value{
A matrix of the covariates
}
\description{
\code{avar} calculated the asymptotic variance of the regression estimation
}
\examples{
hhid <- c("a","b","c","a","b","c" ,"a","b","c" ,"a","b","c" ,"a","b","c")
tid <- c("1","1" ,"1" ,"2","2" ,"3","3","3" ,"4","4","5" ,"5","6","6" ,"6")
w <- rep(1, 15)
x1 <- rnorm(15, mean=50, sd=10)   
x2 <- rnorm(15, mean=50, sd=10)
y <- x1 + rnorm(15, mean=50, sd=10)

struc <- projdummies(hhid, tid, w)
projvar_list <- projvar(x1, struc)
x1p <- projvar_list$var
projvar_list <- projvar(x2, struc)
x2p <- projvar_list$var
projvar_list <- projvar(y, struc)
yp <- projvar_list$var

reg <- regress1(yp, data.frame(x1p,x2p))
matCov <- avar(data.frame(x1p, x2p), reg$res, struc$hhid, reg$XX)
}
