% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-new.R
\name{new-metric}
\alias{new-metric}
\alias{new_class_metric}
\alias{new_prob_metric}
\alias{new_numeric_metric}
\title{Construct a new metric function}
\usage{
new_class_metric(fn, direction)

new_prob_metric(fn, direction)

new_numeric_metric(fn, direction)
}
\arguments{
\item{fn}{A function. The metric function to attach a metric-specific class
and \code{direction} attribute to.}

\item{direction}{A string. One of:
\itemize{
\item \code{"maximize"}
\item \code{"minimize"}
\item \code{"zero"}
}}
}
\description{
These functions provide convenient wrappers to create the three types of
metric functions in yardstick: numeric metrics, class metrics, and
class probability metrics. They add a metric-specific class to \code{fn} and
attach a \code{direction} attribute. These features are used by \code{\link[=metric_set]{metric_set()}}
and by \href{https://tune.tidymodels.org/}{tune} when model tuning.

See \code{vignette("custom-metrics")} for more information about creating custom
metrics.
}
