% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_learn.R
\name{dist_learn}
\alias{dist_learn}
\title{Distributed learning for a longitudinal continuous-time zero-inflated Poisson
hidden Markov model, where zero-inflation only happens in State 1. Assume that
prior, transition rate are subject-specific, but the state-dependent parameters
are the same across subjects. A distributed learning algorithm
is used to estimate the parameters.}
\usage{
dist_learn(ylist, timelist, prior_init, tpm_init, emit_init, zero_init,
  yceil = NULL, rho = 1, maxit = 100, tol = 1e-04, ncores = 1,
  method = "CG", print = TRUE, libpath = NULL, ...)
}
\arguments{
\item{ylist}{list of observed time series values for each subject}

\item{timelist}{list of time indices}

\item{prior_init}{a vector of initial values for prior probability for each state}

\item{tpm_init}{a matrix of initial values for transition rate matrix}

\item{emit_init}{a vector of initial values for the means for each poisson distribution}

\item{zero_init}{a scalar initial value for the structural zero proportion}

\item{yceil}{a scalar defining the ceiling of y, above which the values will be
truncated. Default to NULL.}

\item{rho}{tuning parameters in the distributed learning algorithm.}

\item{maxit}{maximum number iteration. Default to 100.}

\item{tol}{tolerance in the terms of the relative change in the norm of the
common coefficients. Default to 1e-4.}

\item{ncores}{number of cores to be used for parallel programming. Default to 1.}

\item{method}{method for the distributed optimization in the ADMM framework.}

\item{print}{whether to print each iteration. Default to TRUE.}

\item{libpath}{path for the ziphsmm library if not the default set up. Default to NULL.}

\item{...}{Further arguments passed on to the optimization methods}
}
\value{
the maximum likelihood estimates of the zero-inflated hidden Markov model
}
\description{
Distributed learning for a longitudinal continuous-time zero-inflated Poisson
hidden Markov model, where zero-inflation only happens in State 1. Assume that
prior, transition rate are subject-specific, but the state-dependent parameters
are the same across subjects. A distributed learning algorithm
is used to estimate the parameters.
}
\examples{
\dontrun{
set.seed(930518)
nsubj <- 20
ns <- 10800
ylist <- vector(mode="list",length=nsubj)
timelist <- vector(mode="list",length=nsubj)
for(n in 1:nsubj){
  rn1 <- runif(1,-0.02,0.02)
  rn2 <- runif(1,-0.02,0.02)
 prior <- c(0.5 + rn1,0.2 + rn2,0.3 - rn1 - rn2)
 omega <- matrix(c(-0.3-rn1-rn2,0.2+rn1,0.1+rn2,
                   0.1+rn1,-0.2-rn1-rn2,0.1+rn2,
                   0.15+rn1,0.2+rn2,-0.35-rn1-rn2),3,3,byrow=TRUE)
 emit <- c(50,200,600)
 zero <- c(0.2,0,0)
 timeindex <- rep(1,1440)
 for(i in 2:ns) timeindex[i] <- timeindex[i-1] + sample(1:4,1)
 timelist[[n]] <- timeindex
 
 result <- hmmsim.cont(ns, 3, prior, omega, emit, zero, timeindex)
 ylist[[n]] <- result$series
}
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(50, 225, 650)
zero_init <- 0.2
tpm_init <- matrix(c(-0.3,0.2,0.1,0.1,-0.2,0.1,0.15,0.2,-0.35),3,3,byrow=TRUE)

result <- dist_learn(ylist, timelist, prior_init, tpm_init, 
                    emit_init, zero_init, rho=10, 
                    maxit=100, tol=1e-4, method="CG")
}
}
\references{
Boyd, S., Parikh, N., Chu, E., Peleato, B. and Eckstein, J., 2011. 
Distributed optimization and statistical learning via the alternating direction method 
of multipliers. Foundations and Trends in Machine Learning, 3(1), pp.1-122.
}
