% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmviterbi2.R
\name{hmmviterbi2}
\alias{hmmviterbi2}
\title{Viterbi algorithm to decode the latent states in hidden Markov models
with covariate values}
\usage{
hmmviterbi2(y, ntimes = NULL, M, workparm, zero_init, prior_x = NULL,
  tpm_x = NULL, emit_x = NULL, zeroinfl_x = NULL, plot = FALSE,
  xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{ntimes}{vector specifying the lengths of individual, 
i.e. independent, time series. If not specified, the responses are assumed to 
form a single time series, i.e. ntimes=length(y)}

\item{M}{number of latent states}

\item{workparm}{a vector of values for working parameters, which is the last element returned 
from hmmfit() function. This consists the generalized logit of prior probabilities 
(except for the 1st state), generalized logit of transition probability matrix
(except for the 1st column), the  logit of nonzero structural zero proportions, and 
the log poisson means}

\item{zero_init}{a vector containing structural zero proportions in each state, e.g. set
zero_init[i] to be 0 if the i-th state is a regular poisson, and otherwise 1.}

\item{prior_x}{matrix of covariates for generalized logit of prior probabilites (excluding the 
1st probability). Default to NULL.}

\item{tpm_x}{matrix of covariates for transition probability matrix (excluding the 1st column).
Default to NULL.}

\item{emit_x}{matrix of covariates for the log poisson means. Default to NULL.}

\item{zeroinfl_x}{matrix of covariates for the nonzero structural zero proportions. Default to NULL.}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states in hidden Markov models
with covariate values
}
\examples{
data(CAT)
y <- CAT$activity
x <- data.matrix(CAT$night)
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,50,100)
zero_init <- c(0.5,0,0)
omega <- matrix(c(0.5,0.3,0.2,0.4,0.3,0.3,0.2,0.4,0.4),3,3,byrow=TRUE)
fit2 <-  hmmfit(y,rep(1440,3),3,prior_init,omega,
     emit_init,zero_init, emit_x=x,zeroinfl_x=x,hessian=FALSE,
     method="Nelder-Mead", control=list(maxit=500,trace=1))
decode <- hmmviterbi2(y,rep(1440,3),3,fit2$working_parameters,zero_init=c(1,0,0),
            emit_x=x,zeroinfl_x=x, plot=TRUE, xlab="time", ylab="count",
            xlim=c(0,360),ylim=c(0,200))


}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
