% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmmviterbi_exp.R
\name{hsmmviterbi_exp}
\alias{hsmmviterbi_exp}
\title{Viterbi algorithm to decode the latent states in hidden semi-Markov models
with covariates where the latent state durations have accelerated failure
time structure}
\usage{
hsmmviterbi_exp(y, M, trunc, dtrate, dtparm, prior, zeroparm, emitparm, tpmparm,
  dt_x, zeroinfl_x, emit_x, tpm_x, plot = FALSE, xlim = NULL, ylim = NULL,
  ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{M}{number of latent states}

\item{trunc}{a vector specifying the truncation at the maximum number of dwelling time 
in each state.}

\item{dtrate}{a vector for the scale parameters in the base exponential
density for the latent state durations.}

\item{dtparm}{a matrix of coefficients for the accelerated failure time
model in each latent state}

\item{prior}{a vector of prior probabilities}

\item{zeroparm}{a vector of regression coefficients for the structural
zero proportion in state 1}

\item{emitparm}{a matrix of regression coefficients for the Poisson
regression in each state}

\item{tpmparm}{a vector of coefficients for the multinomial logistic
regression in the transition probabilities}

\item{dt_x}{a matrix of covariates for the latent state durations}

\item{zeroinfl_x}{a matrix of covariates for the zero proportion}

\item{emit_x}{a matrix of covariates for the Poisson means}

\item{tpm_x}{a matrix of covariates for the transition}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states in hidden semi-Markov models
with covariates where the latent state durations have accelerated failure
time structure
}
\examples{
\dontrun{
M <- 3
prior <- c(0.5,0.3,0.2)
dtrate <- c(6,5,4)
dtparm <- matrix(c(0.2,0.1,0.2),nrow=3)
zeroparm <- c(0,-0.2)
emitparm <- matrix(c(4,0.3,5,0.2,6,-0.1),3,2,byrow=TRUE)
tpmparm <- c(1,0.2,0.5,-0.2,0,0.2)

emit_x <- matrix(c(rep(1,1000),rep(0,1000)),nrow=2000,ncol=1)
dt_x <- emit_x
tpm_x <- emit_x
zeroinfl_x <- emit_x
trunc <- c(18,15,10)

re <- hsmmsim2_exp(prior,dtrate,dtparm,zeroparm,emitparm,tpmparm,
                  trunc, M, n, dt_x,tpm_x, emit_x, zeroinfl_x)
y <- re$series

rrr <- hsmmfit_exp(y,M,trunc,dtrate,dtparm,prior,zeroparm,emitparm,tpmparm,
                  dt_x,zeroinfl_x,emit_x,tpm_x,method="BFGS",control=list(trace=1))

decode <- hsmmviterbi_exp(y,M, trunc,dtrate,dtparm,
                          prior,zeroparm,emitparm,tpmparm,
                          dt_x, zeroinfl_x, emit_x, tpm_x)
sum(decode!=re$state)
}
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
