% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WALDCC.R
\name{WALDCC}
\alias{WALDCC}
\title{WALDCC: Wald Method with Continuity Correction for Simultaneous Confidence Intervals}
\usage{
WALDCC(inpmat, alpha)
}
\arguments{
\item{inpmat}{Integer vector of observed cell counts corresponding to a
categorical dataset. All values must be non-negative.}

\item{alpha}{Desired statistical significance level}
}
\value{
Prints the original and adjusted confidence intervals for each category,
along with the volume (product of interval widths).
}
\description{
Computes Wald-type simultaneous confidence intervals for multinomial
proportions, incorporating a continuity correction. These intervals are
symmetric about the sample proportions and apply a small correction to
improve coverage accuracy, particularly for small samples.
}
\details{
The correction term 1/2n ensures more accurate interval bounds,
especially when the proportions are near 0 or 1.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
WALDCC(y, z)

}
\references{
Wald, A. (1943).
*Tests of Statistical Hypotheses Concerning Several Parameters When the Number of Observations is Large.*
Transactions of the American Mathematical Society, **54**, 426–482.
}
\seealso{
\code{\link{BMDE}}, \code{\link{WALD}}, \code{\link{SG}}
}
\author{
Dr. M. Subbiah
}
