% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfdb-io.R
\name{wfdb}
\alias{wfdb}
\title{Waveform Database (WFDB) Software Package}
\arguments{
\item{record}{String that will be used to name the WFDB record. Cannot
include extensions, and is not a filepath. alphanumeric characters are
acceptable, as well as hyphens (-) and underscores (_)}

\item{record_dir}{File path of directory that should be used read and write
files. Defaults to current directory.}

\item{annotator}{String that is the name of a WFDB-compatible annotation
type, serving as the extension for the file that is written containing that
annotation. Please see \code{\link[=read_annotation]{read_annotation()}} and \code{\link[=write_annotation]{write_annotation()}} for
further details.}

\item{wfdb_path}{Path that leads to installed \code{wfdb} software package on
device. Needs to be directly set using \code{set_wfdb_path()}. Obtained from the
system options on loading of the package, \code{getOption('wfdb_path')}}

\item{...}{Additional arguments to be passed to the function}
}
\description{
This implementation of WFDB is a back-end for the WFDB using a combination of
\emph{python}, \emph{C++}, and \emph{C} language. The related functions are documented
separately. This serves as an overview of the conversion of WFDB formats to R
formats. In this documentation, the specific WFDB generated files will be
described.
}
\section{WFDB}{
The WFDB (Waveform Database) Software Package has been developed over the
past thirty years, providing a large collection of software for processing
and analyzing physiological waveforms. The package is written in highly
portable C and can be used on all popular platforms, including GNU/Linux,
MacOS X, MS-Windows, and all versions of Unix.

The foundation of the WFDB Software Package is the WFDB library,
consisting of a set of functions for reading and writing digitized signals
and annotations. These functions can be used by programs written in C, C++,
or Fortran, running under any operating system for which an ANSI/ISO C
compiler is available, including all versions of Unix, MS-DOS, MS-Windows,
the Macintosh OS, and VMS.
}

\section{Data format}{
The records that the WFDB uses have three components...
\enumerate{
\item Signals: integer values that are at equal intervals at a certain sampling
frequency
\item Header attributes: recording information such as sample number, gain,
sampling frequency
\item Annotations: information about the record such as a beat labels or alarm
triggers
}
}

\author{
Original software: George Moody, Tom Pollard, Benjamin Moody \cr
R implementation: Anish S. Shah \cr
Last updated: 2025-10-13 \cr
}
