#' @description
#' The package provides tools and methods to apply the model Geospatial
#' Regression Equation for European Nutrient losses (GREEN;
#' Grizzetti et al. (2005); Grizzetti et al. (2012); Grizzetti et al. (2021)) to
#' an area of interest in R environment. The package comprises functions for
#' assessing annual nutrient (nitrogen and phosphorus) loads from a basin or
#' region of interest, land and river retention, and contribution shares by
#' sources. A brief description of the model, including sources and parameters,
#' can be found at the end of this document. Further, the package includes
#' functions for loading spatio-temporal data , calibrating basin parameters,
#' performing an advanced sensitivity analysis to evaluate the calibration
#' results, and visualizing model inputs and outputs through plots and maps.
#' The package is parallel-capable to alleviate the computational burden in
#' large basins.
#'
#'
#' @references
#' Grizzetti, B., Bouraoui, F., De Marsily, G., & Bidoglio, G. (2005). A
#' statistical method for source apportionment of riverine nitrogen loads.
#' Journal of Hydrology, 304(1-4), 302-315.
#' \doi{doi:10.1016/j.jhydrol.2004.07.036}
#'
#' Grizzetti, B., Bouraoui, F., De Marsily, G., (2008). Assessing nitrogen
#' pressures on European surface water. Global Biogeochem. Cycles 22..
#'
#' Grizzetti, B., Bouraoui, F., & Aloe, A. (2012). Changes of nitrogen and
#' phosphorus loads to European seas. Global Change Biology, 18(2), 769-782.
#' \doi{doi:10.1111/j.1365-2486.2011.02576.x}
#'
#' Grizzetti, B., Vigiak, O., Udias, A., Aloe, A., Zanni, M., Bouraoui, F.,
#' Pistocchi, A., Dorati, C., Friedland, R., De Roo, A., others & Bielza, M.
#' (2021). How EU policies could reduce nutrient pollution in European inland
#' and coastal waters. Global Environmental Change, 69, 102281.
#' \doi{doi:10.1016/j.gloenvcha.2021.102281}
#' @keywords internal
"_PACKAGE"
