% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding-objects.R
\name{with_labels}
\alias{with_labels}
\alias{with_labels.IssuesTB}
\title{Check for labels in GitHub Issues}
\usage{
with_labels(x, ...)

\method{with_labels}{IssuesTB}(x, ...)
}
\arguments{
\item{x}{An object of class \code{IssuesTB}.}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}}, such as \code{pattern}
and \code{ignore.case}.}
}
\value{
An object \code{IssuesTB} with issues that satisfy the condition.
}
\description{
Generic function to search for issues with labels
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "open_issues.yaml"
)
with_labels(all_issues, pattern = "Bug")

}
