% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moving_average_smooth.R
\name{moving_average_smooth}
\alias{moving_average_smooth}
\title{Weighted Moving Average}
\usage{
moving_average_smooth(signal, window, max_smooth_iteration = 12)
}
\arguments{
\item{signal}{Signal values (Numeric | vector)}

\item{window}{filter weights for smoothing (Numeric | vector)}

\item{max_smooth_iteration}{Maximum number of iterations of moving average algorithm (Integer)}
}
\value{
smooth signal
}
\description{
Weighted Moving Average Smoothing
}
\details{
Weighted Moving Average Smoothing is used to smooth en the mean and envelope signal
}
\examples{
x=0:100
y = (2 / 3 )* sin(x * 30) + (2 / 3) * sin(x * 17.5) + (4 / 5) *cos(x * 2)
plot(y,type="l")
wma=moving_average_smooth(y,5)
plot(wma,type="l")
}
\references{
\url{https://pypi.org/project/PyLMD/}
}
\author{
Shubhra Prakash, \email{shubhraprakash279@gmail.com}
}
\keyword{Average}
\keyword{Moving}
\keyword{Weighted}
\keyword{wma}
