test_that("Shiny app directory is bundled with the package", {
  app_dir <- system.file("shiny", package = "LifeTableBuilder")
  expect_true(nzchar(app_dir))
  expect_true(dir.exists(app_dir))
  
  # Debe contener archivos (app.R o ui.R/server.R, etc.)
  files <- list.files(app_dir, recursive = TRUE, all.files = TRUE)
  expect_true(length(files) > 0)
})

test_that("run_app() and LifeTableBuilder() are interactive-only", {
  # Esta prueba solo tiene sentido cuando NO estamos en sesión interactiva.
  # En RStudio (interactive() == TRUE) no debemos abrir la app durante tests.
  skip_if(interactive(), "Skipping interactive-only launcher test in interactive sessions.")
  
  expect_error(
    LifeTableBuilder::run_app(),
    "interactive use only"
  )
  
  expect_error(
    LifeTableBuilder::LifeTableBuilder(),
    "interactive use only"
  )
})
