% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_surv_model}
\alias{f_surv_model}
\title{Fit Parametric Survival Models}
\usage{
f_surv_model(
  years,
  status,
  group,
  strata,
  ngroups,
  form,
  spline_mod,
  cure_mod,
  cure_link,
  group_names
)
}
\arguments{
\item{years}{Numeric vector of time-to-event data.}

\item{status}{Numeric vector indicating event occurrence (1 = event, 0 = censoring).}

\item{group}{Factor indicating group membership.}

\item{strata}{Logical. Whether to stratify models by group.}

\item{ngroups}{Integer. Number of groups.}

\item{form}{A survival model formula (e.g., \code{Surv(years, status) ~ group}).}

\item{spline_mod}{Logical. Whether spline models should be fitted.}

\item{cure_mod}{Logical. Whether cure models should be fitted.}

\item{cure_link}{Character string specifying the link function for cure models
("logistic", "loglog", "identity", "probit"; default = "logistic").}

\item{group_names}{Character vector of group labels (for cure fractions).}
}
\value{
A list containing:
\itemize{
\item \code{param_models}, \code{param_ic}: Parametric models and information criteria.
\item \code{spline_models}, \code{spline_ic}: Spline models and IC (if fitted).
\item \code{cure_models}, \code{cure_ic}: Cure models and IC (if fitted).
}
}
\description{
Fits standard parametric models, spline models, and cure models
using the \pkg{flexsurv} package.
}
\details{
Models fitted include Exponential, Weibull, Gompertz, Log-normal,
Log-logistic, Gamma, Generalised Gamma. Optional spline models
(1-3 knots, scales: hazard, odds, normal) and cure models
(Weibull, Log-normal, Log-logistic with logistic/probit/etc. link).
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
form <- stats::as.formula(survival::Surv(years, status) ~ group)
f_surv_model(
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  ngroups = nlevels(group),
  form = form,
  spline_mod = FALSE,
  cure_mod = FALSE,
  cure_link = "logistic",
  group_names = levels(group)
)

}
