% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_gbif.R
\name{request_gbif}
\alias{request_gbif}
\title{Submit a request to download occurrence data from GBIF.}
\usage{
request_gbif(gbif_info, hasCoordinate = TRUE,
                    hasGeospatialIssue = FALSE, format = "DWCA",
                    gbif_user = NULL, gbif_pwd = NULL, gbif_email = NULL,
                    additional_predicates = NULL)
}
\arguments{
\item{gbif_info}{an object of class 'gbif_info' resulted by the
\code{prepare_gbif_download()} function.}

\item{hasCoordinate}{(logical) whether to retrieve only records with coordinates. Default is TRUE.}

\item{hasGeospatialIssue}{(logical) whether to retrieve records identified with geospatial issue. Default is FALSE.}

\item{format}{(character) the download format. Options available are 'DWCA',
'SIMPLE_CSV', or 'SPECIES_LIST', Default is DWCA'.}

\item{gbif_user}{(character) user name within GBIF's website. Default is
NULL, meaning it will try to obtain this information from the R enviroment.
(check \code{set_gbif_credentials()}) for more details.}

\item{gbif_pwd}{(character) user password within GBIF's website. Default is
NULL, meaning it will try to obtain this information from the R enviroment.}

\item{gbif_email}{(character) user email within GBIF's website. Default is
NULL, meaning it will try to obtain this information from the R enviroment.}

\item{additional_predicates}{(character or occ_predicate) additional
supported predicates that can be combined to build more complex download requests. See
\code{rgbif::pred()} for details.}
}
\value{
A download request key returned by the GBIF API, which can be used to monitor
or retrieve the download.
}
\description{
Submit a request to download occurrence data from GBIF.
}
\details{
You can use the object returned by this function to check the download
request progress with \code{rgbif::occ_download_wait()}
}
\note{
This function requires an active internet connection and valid GBIF
credentials.
}
\examples{
\dontrun{
# Prepare data to request GBIF download
gbif_prepared <- prepare_gbif_download(species = "Araucaria angustifolia")
# Submit a request to download occurrences
gbif_requested <- request_gbif(gbif_info = gbif_prepared)
# Check progress
rgbif::occ_download_wait(gbif_requested)
}
}
