% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetectCpObj.R
\name{posterior_estimate.DetectCpObj}
\alias{posterior_estimate.DetectCpObj}
\title{Estimate the change points of the data}
\usage{
\method{posterior_estimate}{DetectCpObj}(
  object,
  loss = "VI",
  maxNClusters = 0,
  nRuns = 16,
  maxZealousAttempts = 10,
  ...
)
}
\arguments{
\item{object}{an object of class \code{DetectCPObj}.}

\item{loss}{The loss function used to estimate the final partition, it can be "VI", "binder", "omARI", "NVI", "ID", "NID".}

\item{maxNClusters}{maximum number of clusters in salso procedure.}

\item{nRuns}{number of runs in salso procedure.}

\item{maxZealousAttempts}{maximum number of zealous attempts in salso procedure.}

\item{...}{parameter of the generic method.}
}
\value{
The function returns a vector with the cluster assignment of each observation.
}
\description{
The \code{posterior_estimate} method estimates the change points of the data making use of the salso algorithm, for a \code{DetectCPObj} class object.
}
\details{
put details here
}
\examples{

data_vec <- as.numeric(c(rnorm(50,0,0.1), rnorm(50,1,0.25)))


out <- detect_cp(data = data_vec, n_iterations = 1000, n_burnin = 100,
                 params = list(q = 0.25, phi = 0.1, a = 1, b = 1, c = 0.1), kernel = "ts")

posterior_estimate(out)

}
\references{
D. B. Dahl, D. J. Johnson, and P. Müller (2022), Search Algorithms and Loss
Functions for Bayesian Clustering, \emph{Journal of Computational and
Graphical Statistics}, 31(4), 1189-1201, \doi{10.1080/10618600.2022.2069779}.
}
