% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggfree.R
\name{ggfree}
\alias{ggfree}
\alias{ggfree.default}
\title{Add ggplot to layout without alignment}
\usage{
ggfree(data = waiver(), ..., size = NULL, active = NULL)

\method{ggfree}{default}(data = waiver(), mapping = aes(), ..., size = NULL, active = NULL)
}
\arguments{
\item{data}{The following options can be used:
\itemize{
\item \code{NULL}: No data is set.
\item \code{\link[ggplot2:waiver]{waiver()}}: Inherits the data from the layout matrix.
\item A \code{function} (including purrr-like lambda syntax): Applied to the layout
matrix to transform the data before use. To transform the final plot
data, please use \code{\link[=scheme_data]{scheme_data()}}.
\item A \code{matrix}, \code{data.frame}, or atomic vector.
}}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{ggfree()} function allows you to incorporate a ggplot object into your
layout. Unlike \code{ggalign()}, which aligns every axis value precisely,
\code{ggfree()} focuses on integrating plots into the layout without enforcing
strict axis alignment.
}
\section{ggplot2 specification}{

\code{ggalign} initializes a ggplot object. The underlying data is created using
\code{\link[=fortify_data_frame]{fortify_data_frame()}}. Please refer to this method for more details.

When used in \code{quad_layout()}/\code{ggheatmap()}, if the data is inherited from the
\code{quad_layout()} and the other direction aligns discrete variables, following
columns will be added:
\itemize{
\item \code{.extra_panel}: Provides the panel information for the column (left or
right annotation) or row (top or bottom annotation).
\item \code{.extra_index}: The index information for the column (left or right
annotation) or row (top or bottom annotation).
}
}

\examples{
ggheatmap(matrix(rnorm(56), nrow = 7)) +
    anno_top() +
    align_dendro() +
    ggfree(mtcars, aes(wt, mpg)) +
    geom_point()
}
