% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-quad-scope.R
\name{quad_scope}
\alias{quad_scope}
\title{Modify operated Context in \code{quad_layout()}}
\usage{
quad_scope(x, position = waiver(), ...)
}
\arguments{
\item{x}{An object which can be added to the ggplot.}

\item{position}{A string or character vector specifying one or more positions
(\code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, and \code{"i"}) indicating where \code{x} should be applied.
Use \code{'i'} to refer to the quad body (i.e., the main plot). If \code{NULL}, the
active annotation context is cleared, behaving as if no annotation is active.
See the \strong{Details} section for more information.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
The original object with an added attribute that sets the specified
context.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{quad_scope()} function controls how plot elements (e.g., themes, scales,
or other ggplot objects) are applied within a \code{ggheatmap()} or
\code{quad_layout()} context. It allows you to direct modifications to specific
annotation positions or the main plot without altering the currently active
layout or nesting state.
}
\details{
Default behavior when adding objects wrapped with \code{quad_scope()}:
\itemize{
\item \strong{When no annotation stack is active}:
Modifications are applied normally without needing \code{quad_scope()}.
\item \strong{When an annotation stack is active}:
\code{quad_scope()} ensures the object is also applied to:
\itemize{
\item The active annotation stack
\item The main plot
}
}

\strong{When \code{position} is manually specified}:
\itemize{
\item If \code{NULL}, it behaves as if no annotation is active
\item If a string, the object is applied only to the
specified positions
(to include the main plot, explicitly add \code{"i"} to \code{position})
}
}
\examples{
set.seed(123)
small_mat <- matrix(rnorm(56), nrow = 7)

# By wrapping object with `quad_scope()`, the `+` operator will apply the
# object not only to the active plot in the annotation stack, but also to
# the main plot unless specified by `main` argument otherwise.
ggheatmap(small_mat) +
    # initialize the left annotation
    anno_left(size = 0.2) +
    align_dendro() +
    # apply the object not only to the active plot in the annotation stack,
    # but also to the main plot
    quad_scope(theme(plot.background = element_rect(fill = "red")))

# When the `position` argument is manually set, the
# we must explicitly include `"i"` in `position` to apply it to the main plot
ggheatmap(small_mat) +
    anno_left(size = 0.2) +
    align_dendro(aes(color = branch), k = 3L) +
    anno_top(size = 0.2) +
    align_dendro(aes(color = branch), k = 3L) +
    anno_bottom(size = 0.2) +
    align_dendro(aes(color = branch), k = 3L) -
    # Modify the background of all plots in the left and top annotation
    quad_scope(theme(plot.background = element_rect(fill = "red")), "tl")
}
