% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_search.R
\name{FacetConfig}
\alias{FacetConfig}
\title{Facet Configuration}
\description{
Configuration for a facet field
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{field}}{Field name to facet on}

\item{\code{limit}}{Max values to return}

\item{\code{min_count}}{Minimum count to include}

\item{\code{sort_by}}{Sort by "count" or "value"}

\item{\code{include_zero}}{Include zero-count values}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FacetConfig-new}{\code{FacetConfig$new()}}
\item \href{#method-FacetConfig-clone}{\code{FacetConfig$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FacetConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-FacetConfig-new}{}}}
\subsection{Method \code{new()}}{
Create a new FacetConfig
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FacetConfig$new(
  field,
  limit = 10,
  min_count = 1,
  sort_by = "count",
  include_zero = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{Field name}

\item{\code{limit}}{Max values (default: 10)}

\item{\code{min_count}}{Min count (default: 1)}

\item{\code{sort_by}}{Sort method (default: "count")}

\item{\code{include_zero}}{Include zeros (default: FALSE)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FacetConfig-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FacetConfig-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FacetConfig$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
