% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{NoCache}
\alias{NoCache}
\title{No-Op Cache}
\description{
Disabled cache (no caching)
}
\section{Super class}{
\code{\link[VectrixDB:BaseCache]{VectrixDB::BaseCache}} -> \code{NoCache}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NoCache-get}{\code{NoCache$get()}}
\item \href{#method-NoCache-set}{\code{NoCache$set()}}
\item \href{#method-NoCache-delete}{\code{NoCache$delete()}}
\item \href{#method-NoCache-exists}{\code{NoCache$exists()}}
\item \href{#method-NoCache-clear}{\code{NoCache$clear()}}
\item \href{#method-NoCache-size}{\code{NoCache$size()}}
\item \href{#method-NoCache-clone}{\code{NoCache$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="delete_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-delete_many'><code>VectrixDB::BaseCache$delete_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="get_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-get_many'><code>VectrixDB::BaseCache$get_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="initialize"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-initialize'><code>VectrixDB::BaseCache$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="make_key"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-make_key'><code>VectrixDB::BaseCache$make_key()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="set_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-set_many'><code>VectrixDB::BaseCache$set_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-get"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-get}{}}}
\subsection{Method \code{get()}}{
Get value from cache (always returns NULL)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-set"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-set}{}}}
\subsection{Method \code{set()}}{
Set cache value (no-op)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$set(key, value, ttl = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}

\item{\code{value}}{Value to cache}

\item{\code{ttl}}{Time-to-live in seconds (ignored)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly returns NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-delete"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-delete}{}}}
\subsection{Method \code{delete()}}{
Delete key from cache (always FALSE)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$delete(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-exists"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-exists}{}}}
\subsection{Method \code{exists()}}{
Check if key exists (always FALSE)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
FALSE
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-clear"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-clear}{}}}
\subsection{Method \code{clear()}}{
Clear cache (no-op)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisibly returns NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-size"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-size}{}}}
\subsection{Method \code{size()}}{
Get cache size (always 0)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer zero
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NoCache-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NoCache-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoCache$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
