% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_curve.R
\name{reference_curve}
\alias{reference_curve}
\title{Contrast an effect curve with a reference point}
\usage{
reference_curve(x, reference)
}
\arguments{
\item{x}{an \code{\link{effect_curve}} object; the output of a call to \code{\link[=adrf]{adrf()}} or a function that modifies it.}

\item{reference}{numeric; the value of the treatment to use as the reference value.}
}
\value{
An object of class \code{reference_curve}, which inherits from \code{\link{effect_curve}}, with the value supplied to \code{reference} as an additional attribute.
}
\description{
\code{reference_curve()} creates a new effect curve as the contrast between each point on a given effect curve and a specified point along that curve. The new curve is called a "reference effect curve".
}
\details{
The value supplied to \code{reference} is added as a grid point on the reference effect curve using the interpolation method described in \code{\link{effect_curve}}. The delta method is used to compute the variance of the difference between each point along the effect curve and the reference point.
}
\examples{
data("nhanes3lead")

fit <- lm(Math ~ poly(logBLL, 5) *
            (Male + Age + Race + PIR +
               Enough_Food),
          data = nhanes3lead)

# ADRF of logBLL on Math, unconditional
# inference
adrf1 <- adrf(fit, treat = "logBLL")

# Differences between ADRF estimates and estimate
# at `logBLL = 0`
ref1 <- reference_curve(adrf1, reference = 0)

ref1

# Plot the reference effect curve
plot(ref1)

# Reference effect curve estimates at given points
ref1(logBLL = c(0, 1, 2)) |>
  summary()

# Test if reference effect curve is 0 (equivalent
# to testing if ADRF is flat)
summary(ref1)
}
\seealso{
\itemize{
\item \code{\link[=adrf]{adrf()}} for computing the ADRF
\item \code{\link[=plot.effect_curve]{plot.effect_curve()}} for plotting the reference effect curve
\item \code{\link[=summary.effect_curve]{summary.effect_curve()}} for testing hypotheses about the reference effect curve
\item \code{\link[=summary.curve_est]{summary.curve_est()}} for performing inference on individual points on an effect curve, including a reference effect curve
\item \code{\link[=point_contrast]{point_contrast()}} for effect curve estimates to each other (rather than to a single point)
}
}
