% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.curve_est.R
\name{summary.curve_est}
\alias{summary.curve_est}
\alias{coef.curve_est}
\alias{vcov.curve_est}
\title{Compute points on an effect curve}
\usage{
\method{summary}{curve_est}(
  object,
  conf_level = 0.95,
  simultaneous = TRUE,
  null = NULL,
  transform = TRUE,
  ci.type = "perc",
  df = NULL,
  ...
)

\method{coef}{curve_est}(object, ...)

\method{vcov}{curve_est}(object, ...)
}
\arguments{
\item{object}{an \code{\link{effect_curve}} object; the output of a call to \code{\link[=adrf]{adrf()}} or a function that modifies it.}

\item{conf_level}{the desired confidence level. Set to 0 to omit confidence intervals. Default is .95.}

\item{simultaneous}{\code{logical}; whether the computed p-values and confidence intervals should be simultaneous (\code{TRUE}) or pointwise (\code{FALSE}). Simultaneous (also known as uniform) intervals jointly cover all specified estimates at the desired confidence level, whereas pointwise confidence intervals only cover each estimate at the desired level. Simultaneous p-values are inversions of the simultaneous confidence intervals. Default is \code{TRUE}. See Details.}

\item{null}{the null value for the hypothesis tests. Default is to use a null value of 0 when the effect curve is an AMEF, a curve contrast, or a reference effect curve, and to omit hypothesis tests otherwise. Set to \code{NA} to manually omit hypothesis tests.}

\item{transform}{whether to compute intervals and perform tests on the transformed estimates. Allowable options include \code{TRUE}, \code{FALSE}, or a function specifying a transformation. Ignored unless \code{object} is an ADRF. See Details.}

\item{ci.type}{string; when bootstrapping or Bayesian inference is used in the original effect curve, which type of confidence interval is to be computed. For bootstrapping, allowable options include \code{"perc"} for percentile intervals, \code{"wald"} for Wald intervals, and other options allowed by \pkgfun{fwb}{summary.fwb}. When \code{simultaneous = TRUE}, only \code{"perc"} and \code{"wald"} are allowed. For Bayesian models, allowable options include \code{"perc"} for equi-tailed intervals and \code{"wald"} for Wald intervals. Default is \code{"perc"}. Ignored when bootstrapping is not used and the model is not Bayesian.}

\item{df}{the "denominator" degrees of freedom to use for the tests and critical test statistics for confidence intervals. Default is to use the residual degrees of freedom from the original model if it is a linear model and \code{Inf} otherwise.}

\item{...}{ignored.}
}
\value{
\code{summary()} returns an object of class \code{summary.curve_est}, which inherits from \code{\link{curve_est}}. This is a \code{data.frame} with columns for the treatment, estimates, and uncertainty measures (p-values, confidence intervals, etc.).
}
\description{
\code{summary()} computes estimates and confidence intervals for specified points on the supplied effect curve.
}
\details{
\subsection{Transform}{

The usual confidence intervals and tests assume the estimates along the effect curve are normally distributed (or t-distributed when \code{df} is not \code{Inf}). However, when the outcome is bounded (e.g., a probability bounded between 0 and 1), this assumption may not be valid for the ADRF in finite samples. \code{transform} transforms the estimates to ones that are unbounded and computes the corresponding distribution of transformed estimates using the delta method. By default, if a generalized linear model is used for the outcome with a non-identity link function, the estimates are transformed by the link function to be on an unbounded scale. Note this is not the same as using the linear predictor for the effect curve; this is simple a transformation of the estimated points along the curve already computed. Confidence intervals are computed using the transformed estimates before being back-transformed to ensure they are within the bounds of the outcome. When \code{null} is a number, that number is also transformed. When \code{transform} is specified, standard errors are not reported (i.e., because the standard errors used for tests and confidence intervals are those of the transformed estimates).
}

\subsection{Simultaneous confidence intervals and tests}{

Simultaneous confidence intervals ensure all estimates, not just a given individual point, are contained within the union of confidence intervals at the given confidence level. These are wider than pointwise intervals to reflect that they are covering multiple estimates, which otherwise would decrease the true coverage rate from that specified. \code{summary()} uses the "sup-t" simultaneous confidence interval, which is the smallest one-parameter interval that covers all estimates at the desired rate. Simultaneous hypothesis tests are performed by inverting the simultaneous confidence intervals; the p-value for each test is the complement of the smallest confidence level for which a simultaneous confidence intervals accounting for other tests contains the null value. The widths of the confidence intervals and the p-values depend on how many and which estimates are computed.
}
}
\examples{
data("nhanes3lead")

fit <- glm(Block >= 12 ~ poly(logBLL, 3) *
             Male * (Age + Race + PIR + NICU +
                       Smoke_Pregnant),
           data = nhanes3lead,
           family = binomial)

# ADRF of logBLL on P(Block >= 12)
adrf1 <- adrf(fit, treat = "logBLL")

# Estimates along ADRF with simultaneous CIs computed
# from transformed estimates
adrf1(logBLL = c(0, 1, 2)) |>
  summary()

# Estimates along ADRF with pointwise CIs computed
# from transformed estimates
adrf1(logBLL = c(0, 1, 2)) |>
  summary(simultaneous = FALSE)

# Estimates along ADRF with simultaneous CIs computed
# from original estimates
adrf1(logBLL = c(0, 1, 2)) |>
  summary(transform = FALSE)

# Estimates along ADRF with simultaneous CIs computed
# from transformed estimates, hypothesis tests against
# null of .1
adrf1(logBLL = c(0, 1, 2)) |>
  summary(null = .1)
}
\seealso{
\itemize{
\item \code{\link[=adrf]{adrf()}} for computing the ADRF
\item \code{\link{curve_est}} for information on the output of an effect curve
\item \code{\link[=plot.effect_curve]{plot.effect_curve()}} for plotting an effect curve
\item \code{\link[=summary.effect_curve]{summary.effect_curve()}} for testing omnibus hypotheses about a effect curve
}
}
