% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{alsi_workflow}
\alias{alsi_workflow}
\title{Example workflow using the ALSI package}
\usage{
alsi_workflow(
  path,
  vars,
  B_pa = 2000,
  B_boot = 2000,
  q = 0.95,
  seed = 20260123
)
}
\arguments{
\item{path}{Path to data file (.xlsx) or data frame}

\item{vars}{Character vector of binary variable names}

\item{B_pa}{Number of permutations for parallel analysis}

\item{B_boot}{Number of bootstrap resamples}

\item{q}{Quantile for parallel analysis}

\item{seed}{Random seed}
}
\value{
List containing all analysis objects
}
\description{
Example workflow using the ALSI package
}
\examples{
\donttest{
# Complete workflow
results <- alsi_workflow(
  path = "ANR2.xlsx",
  vars = c("MDD", "DYS", "DEP", "PTSD", "OCD", "GAD", "ANX", "SOPH", "ADHD"),
  B_pa = 2000,
  B_boot = 2000
)

# Access components
results$pa       # Parallel analysis
results$boot     # Bootstrap stability
results$alsi     # ALSI values
}
}
