% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R, R/mock_bids.R
\name{search_files}
\alias{search_files}
\alias{search_files.bids_project}
\alias{search_files.mock_bids_project}
\title{Search files in BIDS structure}
\usage{
search_files(x, ...)

\method{search_files}{bids_project}(x, regex = ".*", full_path = FALSE, strict = TRUE, ...)

\method{search_files}{mock_bids_project}(x, regex = ".*", full_path = FALSE, strict = TRUE, ...)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{...}{Additional BIDS entities to match (e.g., \code{subid = "01"}, \code{task = "rest"}).
Values are treated as regex patterns unless they are simple strings without regex characters.}

\item{regex}{A regular expression to match filenames (node names). Default \code{".*"}.}

\item{full_path}{If \code{TRUE}, return full paths (prefixed with \code{x$path}).
If \code{FALSE}, return relative paths within the BIDS structure. Default \code{FALSE}.}

\item{strict}{If \code{TRUE} (default), queries for a BIDS entity (e.g., \code{task="X"})
require the entity to exist on the file node and match the pattern.
If \code{FALSE}, files lacking the queried entity are not automatically excluded
(though they won't match if the pattern isn't \verb{.*}).}
}
\value{
A character vector of file paths matching the criteria, or NULL if no matches found.

A character vector of file paths matching the criteria, or NULL if no matches found.

A character vector of matching file paths, or \code{NULL} if no matches.
}
\description{
This function searches for files in a BIDS project that match a specified pattern and
optional key-value criteria. It can be used to find files in both raw data and preprocessed
derivatives based on filename patterns and BIDS metadata.

This function searches for files in a BIDS project that match a specified pattern
and optional key-value criteria. It can search in both raw data and preprocessed
derivatives (if available).

Finds files in the mock BIDS tree by matching file names and BIDS entities.
}
\examples{
\donttest{
# Search for event files in a BIDS dataset  
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path, fmriprep=FALSE)
  event_files <- search_files(proj, regex="events\\\\.tsv$")
  
  # Search with additional criteria
  sub01_files <- search_files(proj, regex="bold\\\\.nii\\\\.gz$", subid="01", 
                              task="balloonanalogrisktask")
  
  # Get full paths
  full_paths <- search_files(proj, regex="events\\\\.tsv$", full_path=TRUE)
  
  # Search with strict matching
  strict_matches <- search_files(proj, regex="\\\\.tsv$", strict=TRUE, 
                                 task="balloonanalogrisktask")
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
\donttest{
# Search for event files in a BIDS dataset
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path, fmriprep=FALSE)
  event_files <- search_files(proj, regex="events\\\\.tsv$")
  
  # Search with additional criteria (note: ds001 only has one subject '01')
  sub01_files <- search_files(proj, regex="bold\\\\.nii\\\\.gz$", subid="01", 
                              task="balloonanalogrisktask")
  
  # Get full paths
  full_paths <- search_files(proj, regex="events\\\\.tsv$", full_path=TRUE)
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
