% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_network.R
\name{sniff_network}
\alias{sniff_network}
\title{Create Citation Networks from Bibliographic Data}
\usage{
sniff_network(dataframe, type = "direct citation", external_references = FALSE)
}
\arguments{
\item{dataframe}{A data frame imported via \code{read_openalex()} or \code{read_wos()}}

\item{type}{Type of network to create. One of:
\itemize{
\item "direct citation": Direct citation links between documents
\item "bibliographic coupling": Documents linked by shared references
}}

\item{external_references}{Logical indicating whether to include external references
(references not in the original dataset) as nodes in the network}
}
\value{
A \code{tbl_graph} object from the tidygraph package representing the citation network.
Node attributes include bibliographic information from the input data.
}
\description{
Constructs different types of citation networks from bibliographic data imported
from Web of Science or OpenAlex using \verb{birddog's} reading functions.
}
\examples{
\dontrun{
# Using OpenAlex data
oa_data <- read_openalex("works.csv", format = "csv")
net <- sniff_network(oa_data, type = "direct citation")

# Using WoS data
wos_data <- read_wos("savedrecs.txt")
net <- sniff_network(wos_data, type = "bibliographic coupling", external_references = TRUE)
}
}
