% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_connect.R
\name{cto_connect}
\alias{cto_connect}
\alias{cto_set_connection}
\alias{cto_is_connected}
\title{Connect to and manage a SurveyCTO Server connection}
\usage{
cto_connect(server, username, password = NULL, cookies = TRUE)

cto_set_connection(session)

cto_is_connected()
}
\arguments{
\item{server}{String. The subdomain of your SurveyCTO server.
For example, if the full URL is \verb{https://my-org.surveycto.com},
set this to \code{"my-org"}.}

\item{username}{String. The username or email address associated with the account.}

\item{password}{String. The user password. If left \code{NULL} (recommended),
it prompts you for the password interactively.}

\item{cookies}{Logical. If \code{TRUE} (default), the client preserves cookies across
requests and handles CSRF tokens automatically. This is required for maintaining
stateful sessions to access endpoints that not available through the REST API.}

\item{session}{A \code{cto_session} object previously created by \code{cto_connect()}.}
}
\value{
\itemize{
\item \code{cto_connect()}: The session object (invisibly).
\item \code{cto_set_connection()}: \code{NULL} (invisibly), called for its side effect of setting the session.
\item \code{cto_is_connected()}: A logical \code{TRUE} or \code{FALSE}.
}
}
\description{
\itemize{
\item \code{cto_connect()} authenticates against a SurveyCTO server, verifies credentials,
and handles cookies.
\item \code{cto_set_connection()} manually sets or restores an existing session object.
\item \code{cto_is_connected()} checks if an active session currently exists in the
internal environment.
}
}
\details{
\subsection{Session Management}{

By default, this package operates \strong{statefully} by preserving cookies
if the connection is established with the \code{cookies = TRUE} argument.
Upon successful authentication, the request object (\code{.session}) is assigned to an internal
package environment (\code{.ctoclient_env}). Therefore, you do not need to pass a request
object to other functions in this package; they will automatically use the
active session. If you are working with multiple servers, please use \code{cto_set_connection()}
to switch the server connection.
}

\subsection{Security Best Practices}{

It is highly recommended to avoid hard-coding passwords in your scripts.
\itemize{
\item \strong{Interactive Session:} Pass the password securely via console input (leave it \code{NULL}) or
keychain management tools.
\item \strong{Automation/Scripts:} Store your credentials in your \code{.Renviron} file
(e.g., \code{SCTO_PASSWORD}) and retrieve them with \code{\link[=Sys.getenv]{Sys.getenv()}}.
}
}
}
\examples{
\dontrun{
# 1. Standard authentication
cto_connect("my-org", "user@org.com", Sys.getenv("SCTO_PASSWORD"))

# 2. Check if connected
cto_is_connected()

# 3. Recommended for interactive use
con <- cto_connect("my-org", "user@org.com")

# 4. Restore and existing connection
cto_set_connection(con)
}
}
\seealso{
\code{\link[httr2:req_auth_basic]{httr2::req_auth_basic()}}, \code{\link[usethis:edit]{usethis::edit_r_environ()}}
}
