% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ernm-fit.R
\name{ernmFit}
\alias{ernmFit}
\title{Fit an ernm}
\usage{
ernmFit(
  sampler,
  theta0,
  mcmcBurnIn = 10000,
  mcmcInterval = 100,
  mcmcSampleSize = 10000,
  minIter = 3,
  maxIter = 40,
  objectiveTolerance = 0.5,
  gradTolerance = 0.25,
  meanStats,
  verbose = 1,
  method = c("bounded", "newton")
)
}
\arguments{
\item{sampler}{the ErnmModel}

\item{theta0}{initial starting values}

\item{mcmcBurnIn}{MCMC burn in}

\item{mcmcInterval}{MCMC interval}

\item{mcmcSampleSize}{MCMC sample size}

\item{minIter}{minimum number of MCMC-MLE iterations}

\item{maxIter}{maximum number of MCMC-MLE iterations}

\item{objectiveTolerance}{convergence criteria on change in log likelihood ratio}

\item{gradTolerance}{convergence criteria on scaled gradient}

\item{meanStats}{optional target statistics for the mean value parameters}

\item{verbose}{level of verbosity 0, 1, or 2}

\item{method}{the optimization method to use. "bounded" uses trust regions around the MCMC sample and is generally preferable. See Fellows (2012) for details.}
}
\value{
an ernm object
}
\description{
This is a lower level MCMC-MLE fitting function for ERNM. Users should generally use
the ernm() function instead.
}
\references{
Fellows, Ian Edward. Exponential family random network models. University of California, Los Angeles, 2012.
}
