% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish}
\alias{publish}
\title{Publishing Functions}
\usage{
publish(source, dest = NULL, connection = NULL, overwrite = TRUE)
}
\arguments{
\item{source}{Character. Local file or directory path to upload.}

\item{dest}{Character or NULL. Destination path in S3 bucket. If NULL,
derives from source filename.}

\item{connection}{Character or NULL. S3 connection name from config.yml.
If NULL, uses the connection marked with \code{default: true}.}

\item{overwrite}{Logical. Whether to overwrite existing files. Default TRUE.}
}
\value{
Character. The public URL(s) of uploaded file(s).
}
\description{
Functions for publishing notebooks, data, and files to S3 storage.

Upload files or directories to an S3 bucket. This is the generic publishing
function - use \code{publish_notebook()} for Quarto documents or \code{publish_data()}
for data files.
}
\examples{
\donttest{
if (FALSE) {
# Upload a single file
publish("outputs/report.html")
# -> https://bucket.s3.region.amazonaws.com/prefix/report.html

# Upload with custom destination
publish("outputs/report.html", dest = "reports/q4-2024.html")

# Upload a directory
publish("outputs/charts/", dest = "reports/charts/")

# Use specific connection
publish("data.csv", connection = "s3_backup")
}
}
}
