% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish_data}
\alias{publish_data}
\title{Publish data to S3}
\usage{
publish_data(data, dest, format = "csv", connection = NULL, compress = FALSE)
}
\arguments{
\item{data}{Data frame or character path to existing file.}

\item{dest}{Character. Destination path in S3 (required for data frames).}

\item{format}{Character. Output format when \code{data} is a data frame:
"csv", "rds", "parquet", or "json". Default "csv".}

\item{connection}{Character or NULL. S3 connection name, or NULL for default.}

\item{compress}{Logical. Whether to gzip compress. Default FALSE.}
}
\value{
Character. Public URL of the published data.
}
\description{
Uploads a data frame or existing data file to S3.
}
\examples{
\donttest{
if (FALSE) {
# Publish a data frame
publish_data(my_df, "datasets/customers.csv")

# Publish as RDS
publish_data(my_df, "datasets/customers.rds", format = "rds")

# Publish existing file
publish_data("outputs/model.rds", "models/v2/model.rds")
}
}
}
