% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVfit.R
\name{CVfit}
\alias{CVfit}
\title{Cross-Validation for Generalized Estimating Equations (GEE)}
\usage{
CVfit(
  formula,
  id,
  data,
  family,
  scale.fix,
  scale.value,
  fold,
  pindex,
  eps,
  maxiter,
  tol,
  lambda.vec = exp(seq(log(10), log(0.1), length.out = 30)),
  corstr = "independence",
  ncore = 1
)
}
\arguments{
\item{formula}{an object of class \code{"formula"} (or one that can be coerced to that class):
a symbolic description of the model to be fitted.}

\item{id}{a vector which identifies the cluster/group for each observation.}

\item{data}{an optional data frame containing the variables in the model.}

\item{family}{a description of the error distribution and link function to be used in the model.}

\item{scale.fix}{logical; if \code{TRUE}, the scale parameter is fixed to \code{scale.value}.}

\item{scale.value}{the value of the scale parameter when \code{scale.fix} is \code{TRUE}.}

\item{fold}{the number of folds to be used in the cross-validation.}

\item{pindex}{an optional numeric vector specifying a parameter index.}

\item{eps}{the threshold for convergence criteria.}

\item{maxiter}{the maximum number of iterations for the convergence of the algorithm.}

\item{tol}{the tolerance level for the convergence of the algorithm.}

\item{lambda.vec}{a vector of lambda values for which the cross-validation error will be calculated.}

\item{corstr}{the correlation structure used.}

\item{ncore}{if greater than 1, the function will use parallel computation.}
}
\value{
An object of class \code{"CVfit"}, which is a list containing:
\describe{
  \item{\code{fold}}{The number of folds used in the cross-validation.}
  \item{\code{lam.vect}}{The vector of lambda values tested.}
  \item{\code{cv.vect}}{The cross-validation error for each lambda.}
  \item{\code{lam.opt}}{The lambda value that resulted in the minimum cross-validation error.}
  \item{\code{cv.min}}{The minimum cross-validation error.}
  \item{\code{call}}{The matched call.}
}
}
\description{
This function performs k-fold cross-validation for model selection in the context
of Generalized Estimating Equations (GEE). It is designed to evaluate the performance
of different models specified by a range of lambda values, choosing the one that
minimizes the cross-validation criterion.
}
\details{
Note that this is a re-implemented version with parallel computing.
}
