% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure-to-iupac.R
\name{structure_to_iupac}
\alias{structure_to_iupac}
\title{Convert Glycan Structure to IUPAC-like Sequence}
\usage{
structure_to_iupac(glycan)
}
\arguments{
\item{glycan}{A glyrepr_structure vector.}
}
\value{
A character vector representing the IUPAC sequences.
}
\description{
Convert a glycan structure to a sequence representation in the form of
mono(linkage)mono, with branches represented by square brackets [].
The backbone is chosen as the longest path, and for branches, linkages are
ordered lexicographically with smaller linkages on the backbone.
}
\section{Sequence Format}{
The sequence follows the format mono(linkage)mono, where:
\itemize{
\item mono: monosaccharide name with optional substituents (e.g., Glc, GlcNAc, Glc3Me)
\item linkage: glycosidic linkage (e.g., b1-4, a1-3)
\item Branches are enclosed in square brackets []
\item Substituents are appended directly to monosaccharide names (e.g., Glc3Me for Glc with 3Me substituent)
}
}

\section{Backbone Selection}{
The backbone is selected as the longest path in the tree. For branches,
the same rule applies recursively.
}

\section{Linkage Comparison}{
Linkages are compared lexicographically:
\enumerate{
\item First by anomeric configuration: ? > b > a
\item Then by first position: ? > numbers (numerically)
\item Finally by second position: ? > numbers (numerically)
}

Smaller linkages are placed on the backbone, larger ones in branches.
}

\examples{
# Simple linear structure
structure_to_iupac(o_glycan_core_1())

# Branched structure  
structure_to_iupac(n_glycan_core())

# Structure with substituents
graph <- igraph::make_graph(~ 1-+2)
igraph::V(graph)$mono <- c("Glc", "GlcNAc")
igraph::V(graph)$sub <- c("3Me", "6Ac")
igraph::E(graph)$linkage <- "b1-4"
graph$anomer <- "a1"
glycan <- glycan_structure(graph)
structure_to_iupac(glycan)  # Returns "GlcNAc6Ac(b1-4)Glc3Me(a1-"

# Vectorized structures
structs <- c(o_glycan_core_1(), n_glycan_core())
structure_to_iupac(structs)

}
