% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_average_treatment.R
\name{boot_grf}
\alias{boot_grf}
\title{Simple clustered bootstrap.}
\usage{
boot_grf(data, statistic, R, clusters, half.sample = TRUE, ...)
}
\arguments{
\item{data}{A data frame with the original data.}

\item{statistic}{A function computing estimate(s) with signature (data, indices, ...) where
data is the original data, and indices a vector which defines the bootstrap sample.}

\item{R}{The number of bootstrap replications.}

\item{clusters}{Integer vector of cluster assignment, setting to 1:N corresponds to an ordinary
unclustered bootstrap.}

\item{half.sample}{Whether to do half sample bootstrap (half the clusters are drawn). Default is TRUE.}

\item{...}{Additional arguments passed on to statistic.}
}
\value{
A list with the original estimate t0, and bootstrap estimates t.
}
\description{
Inspired by the `boot` function in the bootstrap package with clusters + half-sampling added.
A future TODO could be to add parallel (not necessarily worth it)
https://stat.ethz.ch/R-manual/R-devel/library/parallel/doc/parallel.pdf
}
\references{
Angelo Canty and Brian Ripley (2021). boot: Bootstrap R (S-Plus) Functions.
}
\keyword{internal}
