% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anvisa.R
\name{anvisa_variables}
\alias{anvisa_variables}
\title{List ANVISA Variables}
\usage{
anvisa_variables(type = "medicines", search = NULL)
}
\arguments{
\item{type}{Character. ANVISA data type code. Default: \code{"medicines"}.
Use \code{\link{anvisa_types}()} to see all valid types.}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive and accent-insensitive.}
}
\value{
A tibble with columns: variable, description.
}
\description{
Returns a tibble with available variables for a given ANVISA data type,
including descriptions.
}
\examples{
anvisa_variables()
anvisa_variables(type = "hemovigilance")
anvisa_variables(search = "registro")
}
\seealso{
Other anvisa: 
\code{\link{anvisa_cache_status}()},
\code{\link{anvisa_clear_cache}()},
\code{\link{anvisa_data}()},
\code{\link{anvisa_info}()},
\code{\link{anvisa_types}()}
}
\concept{anvisa}
