% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidra_url.R
\name{fetch_sidra_url}
\alias{fetch_sidra_url}
\title{Fetch data from a SIDRA API URL}
\usage{
fetch_sidra_url(url, validate = TRUE)
}
\arguments{
\item{url}{Character string. A SIDRA API URL, typically starting with
\verb{https://apisidra.ibge.gov.br/values/}.}

\item{validate}{Logical. If \code{TRUE} (default), validates parameters against
aggregate metadata before querying.}
}
\value{
A \link[tibble:tibble]{tibble} in tidy (long) format, same as
\code{\link[=ibge_variables]{ibge_variables()}}.
}
\description{
Parses a SIDRA API URL and fetches the data using \code{\link[=ibge_variables]{ibge_variables()}},
returning the same tidy tibble format.
}
\examples{
\dontrun{
url <- "https://apisidra.ibge.gov.br/values/t/7060/n1/all/v/63/p/last\%2012/c315/7169"
fetch_sidra_url(url)

# Pipe-friendly: inspect then fetch
url |> parse_sidra_url()
url |> fetch_sidra_url()
}

}
