% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{page.rank}
\alias{page.rank}
\title{The Page Rank algorithm}
\usage{
page.rank(
  graph,
  algo = c("prpack", "arpack"),
  vids = V(graph),
  directed = TRUE,
  damping = 0.85,
  personalized = NULL,
  weights = NULL,
  options = NULL
)
}
\arguments{
\item{graph}{The graph object.}

\item{algo}{Character scalar, which implementation to use to carry out the
calculation. The default is \code{"prpack"}, which uses the PRPACK library
(\url{https://github.com/dgleich/prpack}) to calculate PageRank scores
by solving a set of linear equations. This is a new implementation in igraph
version 0.7, and the suggested one, as it is the most stable and the fastest
for all but small graphs.  \code{"arpack"} uses the ARPACK library, the
default implementation from igraph version 0.5 until version 0.7. It computes
PageRank scores by solving an eingevalue problem.}

\item{vids}{The vertices of interest.}

\item{directed}{Logical, if true directed paths will be considered for
directed graphs. It is ignored for undirected graphs.}

\item{damping}{The damping factor (\sQuote{d} in the original paper).}

\item{personalized}{Optional vector giving a probability distribution to
calculate personalized PageRank. For personalized PageRank, the probability
of jumping to a node when abandoning the random walk is not uniform, but it
is given by this vector. The vector should contains an entry for each vertex
and it will be rescaled to sum up to one.}

\item{weights}{A numerical vector or \code{NULL}. This argument can be used
to give edge weights for calculating the weighted PageRank of vertices. If
this is \code{NULL} and the graph has a \code{weight} edge attribute then
that is used. If \code{weights} is a numerical vector then it used, even if
the graph has a \code{weights} edge attribute. If this is \code{NA}, then no
edge weights are used (even if the graph has a \code{weight} edge attribute.
This function interprets edge weights as connection strengths. In the
random surfer model, an edge with a larger weight is more likely to be
selected by the surfer.}

\item{options}{A named list, to override some ARPACK options. See
\code{\link[=arpack]{arpack()}} for details. This argument is ignored if the PRPACK
implementation is used.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{page.rank()} was renamed to \code{\link[=page_rank]{page_rank()}} to create a more
consistent API.
}
\keyword{internal}
