\name{stepclass}
\alias{stepclass}
\encoding{latin1}
\alias{stepclass.default}
\alias{stepclass.formula}
\alias{print.stepclass}
\alias{plot.stepclass}
\title{Stepwise variable selection for classification}
\description{
Forward/backward variable selection for classification using any specified 
classification function and selecting by estimated classification performance measure from \code{\link{ucpm}}.
}
\usage{
stepclass(x, ...)

\method{stepclass}{default}(x, grouping, method, improvement = 0.05, maxvar = Inf, 
    start.vars = NULL, direction = c("both", "forward", "backward"), 
    criterion = "CR",  fold = 10, cv.groups = NULL, output = TRUE, 
    min1var = TRUE, ...)
\method{stepclass}{formula}(formula, data, method, ...)
}
\arguments{
\item{x}{matrix or data frame containing the explanatory variables 
    (required, if \code{formula} is not given).}
\item{formula}{A formula of the form \code{groups ~ x1 + x2 + ...}. 
    That is, the response is the grouping factor and the right hand side 
    specifies the (non-factor) discriminators. 
    Interaction terms are not supported.}
\item{data}{data matrix (rows=cases, columns=variables)}
\item{grouping}{class indicator vector (a factor)}
\item{method}{character, name of classification function 
    (e.g. \dQuote{\code{\link[MASS]{lda}}}).}
\item{improvement}{least improvement of performance measure desired 
    to include or exclude any variable (<=1)}
\item{maxvar}{maximum number of variables in model}
\item{start.vars}{set variables to start with (indices or names). 
    Default is no variables if \sQuote{\code{direction}} is 
    \dQuote{\code{forward}} or \dQuote{\code{both}}, 
    and all variables if \sQuote{\code{direction}} is \dQuote{\code{backward}}.}
\item{direction}{\dQuote{\code{forward}}, \dQuote{\code{backward}} or 
    \dQuote{\code{both}} (default)}
\item{criterion}{performance measure taken from \code{\link{ucpm}}.}
\item{fold}{parameter for cross-validation; omitted if \sQuote{\code{cv.groups}} is specified.}                                            
\item{cv.groups}{vector of group indicators for cross-validation. 
    By default assigned automatically.}
\item{output}{indicator (logical) for textoutput during computation (slows down computation!)}
\item{min1var}{logical, whether to include at least one variable in the model, 
    even if the prior itself already is a reasonable model.}
\item{...}{further parameters passed to classification function (\sQuote{\code{method}}), e.g. priors etc.}
}
\details{
The classification \dQuote{method} (e.g. \sQuote{\code{\link[MASS]{lda}}}) must have its own 
\sQuote{\code{predict}} method (like \sQuote{\code{\link[MASS]{predict.lda}}} for \sQuote{\code{lda}}) 
that either returns a matrix of posterior probabilities or a list with an element \sQuote{\code{posterior}} containing 
that matrix instead. It must be able to deal with matrices as in \code{method(x, grouping, ...)}

Then a stepwise variable selection is performed. 
The initial model is defined by the provided starting variables; 
in every step new models are generated by including every single 
variable that is not in the model, and by excluding every single 
variable that is in the model. The resulting performance measure for these 
models are estimated (by cross-validation), and if the maximum value of the chosen
criterion is better than \sQuote{\code{improvement}} plus the value so far, the 
corresponding variable is in- or excluded. The procedure stops, if
the new best value is not good enough, or if the specified maximum 
number of variables is reached.

If \sQuote{\code{direction}} is \dQuote{\code{forward}}, the model is only extended (by including 
further variables), if \sQuote{\code{direction}} is \dQuote{\code{backward}}, the model is only 
reduced (by excluding variables from the model).
}
\value{
An object of class \sQuote{\code{stepclass}} containing the following components:
\item{call}{the (matched) function call.}
\item{method}{name of classification function used (e.g. \dQuote{\code{lda}}).}
\item{start.variables}{vector of starting variables.}
\item{process}{data frame showing selection process (included/excluded variables and performance measure).} 
\item{model}{the final model: data frame with 2 columns; indices and names of variables.}
\item{perfomance.measure}{value of the criterion used by \code{\link{ucpm}}}
\item{formula}{formula of the form \sQuote{\code{response ~ list + of + selected + variables}}}
}
\author{Christian Rver, \email{roever@statistik.tu-dortmund.de}, Irina Czogiel}
\seealso{
\code{\link[stats]{step}}, \code{\link[MASS]{stepAIC}}, 
    and \code{\link{greedy.wilks}} for stepwise variable selection according to Wilk's lambda
}
\examples{
data(iris)
library(MASS)
iris.d <- iris[,1:4]  # the data    
iris.c <- iris[,5]    # the classes 
sc_obj <- stepclass(iris.d, iris.c, "lda", start.vars = "Sepal.Width")
sc_obj
plot(sc_obj)

## or using formulas:
sc_obj <- stepclass(Species ~ ., data = iris, method = "qda", 
    start.vars = "Sepal.Width", criterion = "AS")  # same as above 
sc_obj
## now you can say stuff like
## qda(sc_obj$formula, data = B3)
}
\keyword{multivariate}
\concept{Stepwise variable selection in classification}
