% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_adapter.R
\name{Ggplot2Adapter}
\alias{Ggplot2Adapter}
\title{ggplot2 System Adapter}
\format{
An R6 class inheriting from SystemAdapter
}
\description{
Adapter for the ggplot2 plotting system. This adapter wraps the existing
ggplot2 functionality to work with the new extensible architecture.
}
\keyword{Check}
\keyword{Initialize}
\keyword{a}
\keyword{adapter}
\keyword{can}
\keyword{ggplot2}
\keyword{handle}
\keyword{if}
\keyword{internal}
\keyword{object}
\keyword{plot}
\keyword{the}
\keyword{this}
\section{Super class}{
\code{\link[maidr:SystemAdapter]{maidr::SystemAdapter}} -> \code{Ggplot2Adapter}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Ggplot2Adapter-new}{\code{Ggplot2Adapter$new()}}
\item \href{#method-Ggplot2Adapter-can_handle}{\code{Ggplot2Adapter$can_handle()}}
\item \href{#method-Ggplot2Adapter-detect_layer_type}{\code{Ggplot2Adapter$detect_layer_type()}}
\item \href{#method-Ggplot2Adapter-create_orchestrator}{\code{Ggplot2Adapter$create_orchestrator()}}
\item \href{#method-Ggplot2Adapter-get_system_name}{\code{Ggplot2Adapter$get_system_name()}}
\item \href{#method-Ggplot2Adapter-get_adapter}{\code{Ggplot2Adapter$get_adapter()}}
\item \href{#method-Ggplot2Adapter-has_facets}{\code{Ggplot2Adapter$has_facets()}}
\item \href{#method-Ggplot2Adapter-is_patchwork}{\code{Ggplot2Adapter$is_patchwork()}}
\item \href{#method-Ggplot2Adapter-clone}{\code{Ggplot2Adapter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-new"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-can_handle"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-can_handle}{}}}
\subsection{Method \code{can_handle()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$can_handle(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The plot object to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if this adapter can handle the object, FALSE otherwise
Detect the type of a single layer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-detect_layer_type"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-detect_layer_type}{}}}
\subsection{Method \code{detect_layer_type()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$detect_layer_type(layer, plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer}}{The ggplot2 layer object to analyze}

\item{\code{plot_object}}{The parent plot object (for context)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
String indicating the layer type (e.g., "bar", "line", "point")
Create an orchestrator for this system (ggplot2)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-create_orchestrator"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-create_orchestrator}{}}}
\subsection{Method \code{create_orchestrator()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$create_orchestrator(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The ggplot2 plot object to process}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
PlotOrchestrator instance
Get the system name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-get_system_name"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-get_system_name}{}}}
\subsection{Method \code{get_system_name()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$get_system_name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
System name string
Get a reference to this adapter (for use by orchestrator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-get_adapter"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-get_adapter}{}}}
\subsection{Method \code{get_adapter()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$get_adapter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self reference
Check if plot has facets
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-has_facets"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-has_facets}{}}}
\subsection{Method \code{has_facets()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$has_facets(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The ggplot2 plot object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if plot has facets, FALSE otherwise
Check if plot is a patchwork plot
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-is_patchwork"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-is_patchwork}{}}}
\subsection{Method \code{is_patchwork()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$is_patchwork(plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{The ggplot2 plot object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if plot is patchwork, FALSE otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Ggplot2Adapter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Ggplot2Adapter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ggplot2Adapter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
