% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kolmogorov.R
\name{kolmogorov}
\alias{kolmogorov}
\alias{row_kolmogorovsmirnov_twosample}
\alias{col_kolmogorovsmirnov_twosample}
\title{Kolmogorov-Smirnov test}
\usage{
row_kolmogorovsmirnov_twosample(x, y, alternative = "two.sided", exact = NA)

col_kolmogorovsmirnov_twosample(x, y, alternative = "two.sided", exact = NA)
}
\arguments{
\item{x}{numeric matrix.}

\item{y}{numeric matrix for the second group of observations.}

\item{alternative}{alternative hypothesis to use for each row/column of x.
A single string or a vector with values for each observation.
Values must be one of "two.sided" (default), "greater" or "less".}

\item{exact}{logical or NA (default) indicator whether an exact p-value should be computed (see Details).
A single value or a logical vector with values for each observation.}
}
\value{
a data.frame where each row contains the results of a Kolmogorov-Smirnov test
performed on the corresponding row/column of x and y.
Each row contains the following information (in order):\cr
1. obs.x - number of x observations\cr
2. obs.y - number of y observations\cr
3. obs.tot - total number of observations\cr
5. statistic - Wilcoxon test statistic\cr
6. pvalue - p-value\cr
8. alternative - chosen alternative hypothesis\cr
9. exact - indicates if exact p-value was computed\cr
}
\description{
Performs a Kolmogorov-Smirnov test on each row/column of the input matrix.
}
\details{
Function to perform two sample Kolmogorov-Smirnov test on rows/columns of
matrices. Main arguments and results were intentionally matched to the
\code{ks.test()} function from default stats package.

Results should be the same as running \code{ks.test(x, y)} on every row (or
column) of \code{x} and \code{y}.

By default if 'exact' argument is set to 'NA', exact p-values are computed
if the product of 'x' and 'y' sample sizes is less than 10000. Otherwise,
asymptotic distributions are used.

Alternative hypothesis setting specifies null and alternative hypotheses.
The possible values of 'two sided', 'less', and 'greater'.
'two sided' sets the null hypothesis for the distributions of 'x' being equal to the distribution 'y'.
'less' sets the null hypothesis for the distribution of x not being less than the distribution of y.
'greater' sets the null hypothesis for the distribution of x not being greater than the distribution of y.
See \code{help(ks.test)} for more details.
}
\examples{
X <- iris[iris$Species=="setosa", 1:4]
Y <- iris[iris$Species=="virginica", 1:4]
col_kolmogorovsmirnov_twosample(X, Y)

# same column using different alternative hypotheses
col_kolmogorovsmirnov_twosample(X[,c(1,1,1)], Y[,c(1,1,1)], alternative=c("t", "g", "l"))

}
\seealso{
\code{ks.test()}
}
\author{
Karolis Koncevičius
}
