% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thselect.R
\name{thselect.pec}
\alias{thselect.pec}
\title{Prediction error C-criterion threshold selection method}
\usage{
thselect.pec(xdat, kmax)
}
\arguments{
\item{xdat}{vector of observations}

\item{kmax}{maximum number of order statistics to consider. Default to sample size if left unspecified.}
}
\value{
a list with the number of exceedances \code{k}, the chosen threshold \code{thresh0} and the corresponding Hill estimator shape estimate \code{shape}.
}
\description{
This function computes the non-robust Pareto prediction error of Dupuis and Victoria-Feser (2003), termed C-criterion, for the Hill estimator of the shape parameter. The threshold returned is the value of the threshold, taken from order statistics, that minimizes the average prediction error.
}
\references{
Dupuis, D.J. and M.-P. Victoria-Feser (2003). A Prediction Error Criterion for Choosing the Lower Quantile in Pareto Index Estimation, University of Geneva, technical report, \url{https://archive-ouverte.unige.ch/unige:5789}.
}
